/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier;

import org.mortbay.jetty.webapp.verifier.Rule;
import org.mortbay.jetty.webapp.verifier.Severity;

public class Violation {
    private String path;
    private Severity severity;
    private String detail;
    private Throwable throwable;
    private String ruleId;
    private Class<? extends Rule> ruleClass;

    public Violation(Severity severity, String path, String detail) {
        this.severity = severity;
        this.path = path;
        this.detail = detail;
    }

    public Violation(Severity severity, String path, String detail, Rule verifier) {
        this.severity = severity;
        this.path = path;
        this.detail = detail;
        this.setVerifierInfo(verifier);
    }

    public Violation(Severity severity, String path, String detail, Throwable throwable) {
        this.severity = severity;
        this.path = path;
        this.detail = detail;
        this.throwable = throwable;
    }

    public void setVerifierInfo(Rule verifier) {
        this.ruleId = verifier.getName();
        this.ruleClass = verifier.getClass();
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append("Violation[");
        msg.append("severity=").append(this.severity.name());
        msg.append(",path=").append(this.path);
        msg.append(",detail=").append(this.detail);
        if (this.ruleId != null) {
            msg.append(",verifierId=").append(this.ruleId);
        }
        if (this.ruleClass != null) {
            msg.append(",verifierClass=").append(this.ruleClass.getName());
        }
        if (this.throwable != null) {
            msg.append(",throwable=").append(this.throwable.getClass().getName());
        }
        msg.append("]");
        return msg.toString();
    }

    public String toDelimString() {
        StringBuffer msg = new StringBuffer();
        msg.append(this.severity.name());
        msg.append("|").append(this.path);
        msg.append("|").append(this.detail);
        return msg.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.detail == null ? 0 : this.detail.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Violation other = (Violation)obj;
        if (this.detail == null ? other.detail != null : !this.detail.equals(other.detail)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.severity == null ? other.severity != null : !this.severity.equals((Object)other.severity));
    }

    public Class<? extends Rule> getRuleClass() {
        return this.ruleClass;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getPath() {
        return this.path;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

