/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mortbay.jetty.webapp.verifier.Rule;
import org.mortbay.jetty.webapp.verifier.WebappVerifier;

public class RuleSet {
    private String name;
    private List<Rule> rules = new ArrayList<Rule>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void setRules(Rule[] ruleArray) {
        this.rules.clear();
        this.rules.addAll(Arrays.asList(ruleArray));
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public WebappVerifier createWebappVerifier(URI webappURI) {
        WebappVerifier webappVerifier = new WebappVerifier(webappURI);
        webappVerifier.setRules(this.rules);
        return webappVerifier;
    }

    public static RuleSet load(URL configuration) throws Exception {
        XmlConfiguration xml = new XmlConfiguration(configuration);
        return (RuleSet)xml.configure();
    }

    public static RuleSet load(URI configuration) throws Exception {
        return RuleSet.load(configuration.toURL());
    }

    public static RuleSet load(File configuration) throws Exception {
        return RuleSet.load(configuration.toURL());
    }
}

