/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.support;

public class PathGlob {
    public static boolean match(String pathSpec, String path) throws IllegalArgumentException {
        return PathGlob.match(pathSpec, path, false);
    }

    public static boolean match(String pathSpec, String path, boolean noDefault) throws IllegalArgumentException {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (!noDefault && pathSpec.length() == 1 || pathSpec.equals(path)) {
                return true;
            }
            if (PathGlob.isPathWildcardMatch(pathSpec, path)) {
                return true;
            }
        } else if (c == '*') {
            return path.regionMatches(path.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
        }
        return false;
    }

    private static boolean isPathWildcardMatch(String pathSpec, String path) {
        int cpl = pathSpec.length() - 2;
        return pathSpec.endsWith("/*") && path.regionMatches(0, pathSpec, 0, cpl) && (path.length() == cpl || '/' == path.charAt(cpl));
    }
}

