/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.AbstractRule;

public class NoScriptingRule
extends AbstractRule {
    private boolean allowJRuby = false;
    private boolean allowBeanshell = false;
    private boolean allowGroovy = false;
    private boolean allowJython = false;
    private boolean allowShell = false;
    private List<Forbidden> forbiddenFileExtensions = new ArrayList<Forbidden>();
    private List<Forbidden> forbiddenClassIds = new ArrayList<Forbidden>();

    public boolean isAllowShell() {
        return this.allowShell;
    }

    public void setAllowShell(boolean allowShell) {
        this.allowShell = allowShell;
    }

    public boolean isAllowJRuby() {
        return this.allowJRuby;
    }

    public void setAllowJRuby(boolean allowJruby) {
        this.allowJRuby = allowJruby;
    }

    public boolean isAllowBeanshell() {
        return this.allowBeanshell;
    }

    public void setAllowBeanshell(boolean allowBeanshell) {
        this.allowBeanshell = allowBeanshell;
    }

    public boolean isAllowGroovy() {
        return this.allowGroovy;
    }

    public void setAllowGroovy(boolean allowGroovy) {
        this.allowGroovy = allowGroovy;
    }

    public boolean isAllowJython() {
        return this.allowJython;
    }

    public void setAllowJython(boolean allowJython) {
        this.allowJython = allowJython;
    }

    @Override
    public String getDescription() {
        return "Do not allow scripting languages in webapp";
    }

    @Override
    public String getName() {
        return "forbidden-scripting";
    }

    @Override
    public void initialize() throws Throwable {
        String msg;
        this.forbiddenFileExtensions.clear();
        this.forbiddenClassIds.clear();
        if (!this.allowJRuby) {
            msg = "JRuby scripting not allowed";
            this.forbiddenFileExtensions.add(new Forbidden(".rb", msg));
            this.forbiddenFileExtensions.add(new Forbidden(".rhtml", msg));
            msg = "JRuby dependencies are not allowed";
            this.forbiddenClassIds.add(new Forbidden(".jruby.", msg));
        }
        if (!this.allowJython) {
            msg = "Jython and Python scripting not allowed";
            this.forbiddenFileExtensions.add(new Forbidden(".py", msg));
            this.forbiddenFileExtensions.add(new Forbidden(".pyc", msg));
            msg = "Jython dependencies are not allowed";
            this.forbiddenClassIds.add(new Forbidden("org.python.", msg));
        }
        if (!this.allowGroovy) {
            msg = "Groovy scripting not allowed";
            this.forbiddenFileExtensions.add(new Forbidden(".groovy", msg));
            msg = "Groovy dependencies are not allowed";
            this.forbiddenClassIds.add(new Forbidden(".groovy.", msg));
        }
        if (!this.allowShell) {
            msg = "Shell scripting not allowed";
            this.forbiddenFileExtensions.add(new Forbidden(".sh", msg));
            this.forbiddenFileExtensions.add(new Forbidden(".bat", msg));
            this.forbiddenFileExtensions.add(new Forbidden(".cmd", msg));
            this.forbiddenFileExtensions.add(new Forbidden(".vbs", msg));
        }
    }

    @Override
    public void visitFile(String path, File dir, File file) {
        String name = file.getName().toLowerCase();
        for (Forbidden forbidden : this.forbiddenFileExtensions) {
            if (!name.endsWith(forbidden.key)) continue;
            this.error(path, forbidden.msg);
        }
    }

    @Override
    public void visitWebInfClass(String path, String className, File classFile) {
        this.validateClassname(path, className);
    }

    private void validateClassname(String path, String className) {
        for (Forbidden forbidden : this.forbiddenClassIds) {
            if (!className.contains(forbidden.key)) continue;
            this.error(path, forbidden.msg);
        }
    }

    @Override
    public void visitWebInfClassResource(String path, String resourcePath, File resourceFile) {
        super.visitWebInfClassResource(path, resourcePath, resourceFile);
    }

    @Override
    public void visitWebInfLibJar(String path, File archive, JarFile jar) {
        this.iterateArchive(path, archive, jar);
    }

    private void iterateArchive(String path, File archive, ZipFile zip) {
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                this.checkArchiveClassname(path, archive, entry.getName());
            }
        }
        catch (Throwable t) {
            this.exception(path, "Unable to iterate archive: Contents invalid?: " + t.getMessage(), t);
        }
    }

    private void checkArchiveClassname(String path, File archive, String name) {
        String className = name.replace("/", ".");
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        this.validateClassname(path + "!/" + name, className);
    }

    @Override
    public void visitWebInfLibZip(String path, File archive, ZipFile zip) {
        this.iterateArchive(path, archive, zip);
    }

    class Forbidden {
        public String key;
        public String msg;

        public Forbidden(String key, String msg) {
            this.key = key;
            this.msg = msg;
        }
    }
}

