/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.AbstractArchiveScanningRule;
import org.mortbay.jetty.webapp.verifier.support.PathGlob;

public class NoNativeRule
extends AbstractArchiveScanningRule {
    private String[] nativePatterns = new String[]{"*.so", "*.so.*", "*.o", "*.dll", "*.com", "*.exe"};

    @Override
    public String getDescription() {
        return "Prevent use of native code in webapp";
    }

    @Override
    public String getName() {
        return "no-native";
    }

    @Override
    public void visitFile(String path, File dir, File file) {
        for (String pattern : this.nativePatterns) {
            if (!PathGlob.match(pattern, path)) continue;
            this.error(path, "Native code is forbidden");
        }
    }

    @Override
    public void visitArchiveResource(String path, ZipFile zip, ZipEntry entry) {
        for (String pattern : this.nativePatterns) {
            if (!PathGlob.match(pattern, entry.getName())) continue;
            this.error(path, "Native code is forbidden");
        }
    }
}

