/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.AbstractArchiveScanningRule;
import org.mortbay.jetty.webapp.verifier.rules.asm.ASMUtil;
import org.mortbay.jetty.webapp.verifier.rules.asm.AbstractClassVisitor;

public class JavaSupportLevelRule
extends AbstractArchiveScanningRule {
    private double supportedVersion = 1.5;
    private ClassVersionVisitor visitor;

    @Override
    public String getDescription() {
        return "Ensure all compiled classes within webapp are within the supported JVM";
    }

    @Override
    public String getName() {
        return "java-support-level";
    }

    public double getSupportedVersion() {
        return this.supportedVersion;
    }

    public void setSupportedVersion(double supportedVersion) {
        this.supportedVersion = supportedVersion;
    }

    @Override
    public void visitWebappStart(String path, File dir) {
        this.visitor = new ClassVersionVisitor();
    }

    @Override
    public void visitWebInfClass(String path, String className, File classFile) {
        try {
            this.visitor.reset();
            ASMUtil.visitClassFile(classFile, this.visitor, 0);
            if (this.visitor.classVersion > this.supportedVersion) {
                this.error(path, "Class is compiled for java version [" + this.visitor.classVersion + "] which is over supported java version [" + this.supportedVersion + "]");
            }
        }
        catch (IOException e) {
            this.exception(path, "Unable to read class", e);
        }
    }

    @Override
    public void visitArchiveClass(String path, String className, ZipFile archive, ZipEntry archiveEntry) {
        try {
            this.visitor.reset();
            ASMUtil.visitClass(archive.getInputStream(archiveEntry), this.visitor, 0);
            if (this.visitor.classVersion > this.supportedVersion) {
                this.error(path, "Class is compiled for java version [" + this.visitor.classVersion + "] which is over supported java version [" + this.supportedVersion + "]");
            }
        }
        catch (IOException e) {
            this.exception(path, "Unable to read class", e);
        }
    }

    class ClassVersionVisitor
    extends AbstractClassVisitor {
        private double classVersion = -1.0;

        ClassVersionVisitor() {
        }

        public double getClassVersion() {
            return this.classVersion;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classVersion = this.getJavaClassVersion(version);
        }

        private double getJavaClassVersion(int version) {
            int major = version & 0xFFFF;
            int minor = version >>> 16;
            if (major >= 50) {
                return 1.6;
            }
            if (major >= 49) {
                return 1.5;
            }
            if (major >= 48) {
                return 1.4;
            }
            if (major >= 47) {
                return 1.3;
            }
            if (major >= 46) {
                return 1.2;
            }
            if (major >= 45) {
                if (minor >= 3) {
                    return 1.1;
                }
                return 1.0;
            }
            return 0.0;
        }

        public void reset() {
            this.classVersion = -1.0;
        }
    }
}

