/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jetty.util.IO;
import org.mortbay.jetty.webapp.verifier.AbstractRule;

public class JarSignatureRule
extends AbstractRule {
    private String _keystoreLocation = System.getProperty("java.home") + "/lib/security/cacerts";
    private String _type = "JKS";
    private String _alias = "verisignclass3ca";
    private KeyStore _keystore;
    private static X509Certificate[] _trustedCertificates;

    @Override
    public String getDescription() {
        return "verifies that the given keystore contains the certificates required for all jar files present";
    }

    @Override
    public String getName() {
        return "jar-signature";
    }

    private List<JarEntry> resolveJar(JarFile jar) {
        ArrayList<JarEntry> entries = new ArrayList<JarEntry>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            try {
                entries.add(jarEntry);
                IO.toString((InputStream)jar.getInputStream(jar.getEntry(jarEntry.getName())));
            }
            catch (IOException e1) {
                throw new SecurityException(e1);
            }
        }
        return entries;
    }

    public void setKeystoreLocation(String keyStoreLocation) {
        this._keystoreLocation = keyStoreLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        block7: {
            X509Certificate x509;
            FileInputStream in;
            block6: {
                in = null;
                this._keystore = KeyStore.getInstance(this._type);
                File keystoreFile = new File(this._keystoreLocation);
                in = new FileInputStream(keystoreFile);
                this._keystore.load(in, null);
                x509 = (X509Certificate)this._keystore.getCertificate(this._alias);
                if (x509 != null) break block6;
                super.error(this._keystoreLocation, "Unable to obtain X509Certificate from keystore");
                IO.close((InputStream)in);
                return;
            }
            try {
                _trustedCertificates = new X509Certificate[]{x509};
            }
            catch (Throwable t) {
                try {
                    this.exception(this._keystoreLocation, t.getMessage(), t);
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IO.close(in);
                }
            }
            IO.close((InputStream)in);
        }
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public void visitWebInfLibJar(String path, File archive, JarFile jar) {
        try {
            if (jar.getManifest() == null) {
                this.error(jar.toString(), "missing manifest.mf, can not be signed");
            }
            List<JarEntry> entries = this.resolveJar(jar);
            for (JarEntry jarEntry : entries) {
                if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF")) continue;
                Certificate[] certs = jarEntry.getCertificates();
                if (certs == null || certs.length == 0) {
                    this.error(jarEntry.getName(), "entry has not been signed");
                    continue;
                }
                X509Certificate[] chainRoots = this.getChainRoots(certs);
                boolean signed = false;
                for (int i = 0; i < chainRoots.length; ++i) {
                    if (!this.isTrusted(chainRoots[i])) continue;
                    signed = true;
                    break;
                }
                if (signed) continue;
                this.error(jarEntry.getName(), "Untrusted provider's JAR");
            }
        }
        catch (Exception e) {
            this.exception(jar.getName(), e.getMessage(), e);
        }
    }

    private boolean isTrusted(X509Certificate certificate) {
        int i;
        for (i = 0; i < _trustedCertificates.length; ++i) {
            if (!((Object)certificate.getSubjectDN()).equals(_trustedCertificates[i].getSubjectDN()) || !certificate.equals(_trustedCertificates[i])) continue;
            return true;
        }
        for (i = 0; i < _trustedCertificates.length; ++i) {
            if (!((Object)certificate.getIssuerDN()).equals(_trustedCertificates[i].getSubjectDN())) continue;
            try {
                certificate.verify(_trustedCertificates[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private X509Certificate[] getChainRoots(Certificate[] certificates) {
        ArrayList<X509Certificate> chainRoots = new ArrayList<X509Certificate>();
        for (int i = 0; i < certificates.length - 1; ++i) {
            if (((Object)((X509Certificate)certificates[i + 1]).getSubjectDN()).equals(((X509Certificate)certificates[i]).getIssuerDN())) continue;
            chainRoots.add((X509Certificate)certificates[i]);
        }
        chainRoots.add((X509Certificate)certificates[certificates.length - 1]);
        return chainRoots.toArray(new X509Certificate[chainRoots.size()]);
    }
}

