/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mortbay.jetty.webapp.verifier.AbstractRule;
import org.mortbay.jetty.webapp.verifier.support.PathGlob;

public class ForbiddenContentsRule
extends AbstractRule {
    private List<String> _patterns = new ArrayList<String>();

    public void addPattern(String pattern) {
        this._patterns.add(pattern);
    }

    @Override
    public String getDescription() {
        return "Checks for forbidden content";
    }

    @Override
    public String getName() {
        return "forbidden-content";
    }

    @Override
    public void visitFile(String path, File dir, File file) {
        for (String pattern : this._patterns) {
            if (!PathGlob.match(pattern, path)) continue;
            this.error(path, "Forbidden content detected");
        }
    }
}

