/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier;

import java.io.File;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.Rule;
import org.mortbay.jetty.webapp.verifier.Severity;
import org.mortbay.jetty.webapp.verifier.Violation;
import org.mortbay.jetty.webapp.verifier.ViolationListener;

public abstract class AbstractRule
implements Rule {
    private ViolationListener violationListener;
    private File rootDir;

    protected void error(String path, String detail) {
        Violation violation = new Violation(Severity.ERROR, path, detail);
        violation.setVerifierInfo(this);
        this.violationListener.reportViolation(violation);
    }

    protected void exception(String path, String detail, Throwable t) {
        Violation violation = new Violation(Severity.ERROR, path, detail, t);
        violation.setVerifierInfo(this);
        this.violationListener.reportViolation(violation);
    }

    protected String getWebappRelativePath(File dir) {
        if (this.rootDir == null) {
            throw new RuntimeException("rootDir is not initialized, can't get relative path.  Did you overide .visitWebappStart() and not call super.visitWebappStart()?");
        }
        return this.rootDir.toURI().relativize(dir.toURI()).toASCIIString();
    }

    @Override
    public void setViolationListener(ViolationListener listener) {
        this.violationListener = listener;
    }

    @Override
    public void initialize() throws Throwable {
    }

    @Override
    public void visitDirectoryEnd(String path, File dir) {
    }

    @Override
    public void visitDirectoryStart(String path, File dir) {
    }

    @Override
    public void visitFile(String path, File dir, File file) {
    }

    @Override
    public void visitWebappEnd(String path, File dir) {
    }

    @Override
    public void visitWebappStart(String path, File dir) {
        if (path.equals("")) {
            this.rootDir = new File(path);
        }
    }

    @Override
    public void visitWebInfClass(String path, String className, File classFile) {
    }

    @Override
    public void visitWebInfClassesEnd(String path, File dir) {
    }

    @Override
    public void visitWebInfClassesStart(String path, File dir) {
    }

    @Override
    public void visitWebInfClassResource(String path, String resourcePath, File resourceFile) {
    }

    @Override
    public void visitWebInfLibEnd(String path, File dir) {
    }

    @Override
    public void visitWebInfLibJar(String path, File archive, JarFile jar) {
    }

    @Override
    public void visitWebInfLibStart(String path, File dir) {
    }

    @Override
    public void visitWebInfLibZip(String path, File archive, ZipFile zip) {
    }

    protected void warning(String path, String detail) {
        Violation violation = new Violation(Severity.WARNING, path, detail);
        violation.setVerifierInfo(this);
        this.violationListener.reportViolation(violation);
    }
}

