/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.verifier;

import java.io.File;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mortbay.jetty.webapp.verifier.AbstractRule;

public abstract class AbstractArchiveScanningRule
extends AbstractRule {
    @Override
    public abstract String getDescription();

    @Override
    public abstract String getName();

    @Override
    public void visitWebInfLibJar(String path, File archive, JarFile jar) {
        this.scanClassesInArchive(path, jar);
    }

    @Override
    public void visitWebInfLibZip(String path, File archive, ZipFile zip) {
        this.scanClassesInArchive(path, zip);
    }

    private String asClassname(String path) {
        StringBuffer name = new StringBuffer();
        for (char c : path.toCharArray()) {
            if (c == '/') {
                name.append(".");
                continue;
            }
            name.append(c);
        }
        if (name.toString().endsWith(".class")) {
            name.delete(name.length() - 6, name.length() - 1);
        }
        return name.toString();
    }

    private void scanClassesInArchive(String path, ZipFile zip) {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.getName().endsWith(".class")) {
                String className = this.asClassname(entry.getName());
                this.visitArchiveClass(path + "!/" + entry.getName(), className, zip, entry);
                continue;
            }
            this.visitArchiveResource(path + "!/" + entry.getName(), zip, entry);
        }
    }

    public void visitArchiveResource(String path, ZipFile zip, ZipEntry entry) {
    }

    public void visitArchiveClass(String path, String className, ZipFile archive, ZipEntry archiveEntry) {
    }
}

