/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.logging;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.logging.CentralizedWebAppLoggingConfiguration;

public class CentralizedLoggingBean
extends AbstractLifeCycle {
    private static final String CONFIG_CLASS = CentralizedWebAppLoggingConfiguration.class.getName();
    private Server server;
    private String configurationFilename;

    public String getConfigurationFilename() {
        return this.configurationFilename;
    }

    public void setConfigurationFilename(String filename) {
        this.configurationFilename = filename;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
        CentralizedLoggingBean.setWebAppContextConfigurations(server);
    }

    protected void doStart() throws Exception {
        CentralizedLoggingBean.setWebAppContextConfigurations(this.server);
        super.doStart();
    }

    public static void setWebAppContextConfigurations(Server server) {
        String[] configs = (String[])server.getAttribute("org.eclipse.jetty.webapp.configuration");
        if (configs == null) {
            WebAppContext wac = new WebAppContext();
            configs = wac.getDefaultConfigurationClasses();
        }
        for (String config : configs) {
            if (!config.equals(CONFIG_CLASS)) continue;
            return;
        }
        String[] newconfigs = new String[configs.length + 1];
        if (configs.length > 0) {
            System.arraycopy(configs, 0, newconfigs, 0, configs.length);
        }
        newconfigs[configs.length] = CONFIG_CLASS;
        server.setAttribute("org.eclipse.jetty.webapp.configuration", (Object)newconfigs);
    }
}

