/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp.logging;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.slf4j.MDC;

public class ContextLogHandler
extends HandlerWrapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Principal principal;
        MDC.put((String)"target", (String)target);
        String contextPath = request.getContextPath();
        if (contextPath != null) {
            MDC.put((String)"contextPath", (String)contextPath);
        }
        MDC.put((String)"remoteAddr", (String)request.getRemoteAddr());
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null) {
            MDC.put((String)"remoteUser", (String)remoteUser);
        }
        if ((principal = request.getUserPrincipal()) != null) {
            MDC.put((String)"principal", (String)principal.getName());
        }
        try {
            super.handle(target, baseRequest, request, response);
        }
        finally {
            MDC.clear();
        }
    }
}

