/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import org.mortbay.log.Log;

public class Timeout {
    private final Object _mutex;
    private long _duration;
    private long _now = System.currentTimeMillis();
    private Task _head = new Task();

    public Timeout() {
        this._mutex = this;
        this._head._timeout = this;
    }

    public Timeout(Object mutex) {
        this._mutex = mutex == null ? this : mutex;
        this._head._timeout = this;
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long duration) {
        this._duration = duration;
    }

    public void setNow() {
        this._now = System.currentTimeMillis();
    }

    public long getNow() {
        return this._now;
    }

    public void setNow(long now) {
        this._now = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long expiry = this._now - this._duration;
        while (true) {
            Task expired = null;
            Object object = this._mutex;
            synchronized (object) {
                if (this._head._next != this._head && this._head._next._timestamp <= expiry) {
                    expired = this._head._next;
                    expired.unlink();
                    expired._expired = true;
                }
            }
            if (expired == null) break;
            try {
                expired.expired();
            }
            catch (Throwable th) {
                Log.warn("EXCEPTION ", th);
            }
        }
    }

    public void schedule(Task task) {
        this.schedule(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, long delay) {
        if (task._timeout != null && task._timeout != this) {
            task.cancel();
        }
        Object object = this._mutex;
        synchronized (object) {
            if (task._timestamp != 0L) {
                task.unlink();
                task._timestamp = 0L;
            }
            task._expired = false;
            task._delay = delay;
            task._timestamp = this._now + delay;
            Task last = this._head._prev;
            while (last != this._head && last._timestamp > task._timestamp) {
                last = last._prev;
            }
            last.setNext(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this._mutex;
        synchronized (object) {
            this._head._next = this._head._prev = this._head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this._mutex;
        synchronized (object) {
            return this._head._next == this._head;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToNext() {
        Object object = this._mutex;
        synchronized (object) {
            if (this._head._next == this._head) {
                return -1L;
            }
            long to_next = this._duration + this._head._next._timestamp - this._now;
            long l = to_next < 0L ? 0L : to_next;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        Object object = this._mutex;
        synchronized (object) {
            Task task = this._head._next;
            while (task != this._head) {
                buf.append("-->");
                buf.append(task);
                task = task._next;
            }
        }
        return buf.toString();
    }

    public static class Task {
        Task _next = this._prev = this;
        Task _prev;
        Timeout _timeout;
        long _delay;
        long _timestamp = 0L;
        boolean _expired = false;

        public long getTimestamp() {
            return this._timestamp;
        }

        public long getAge() {
            Timeout t = this._timeout;
            if (t != null && t._now != 0L && this._timestamp != 0L) {
                return t._now - this._timestamp;
            }
            return 0L;
        }

        private void unlink() {
            this._next._prev = this._prev;
            this._prev._next = this._next;
            this._next = this._prev = this;
            this._timeout = null;
            this._expired = false;
        }

        private void setNext(Task task) {
            if (this._timeout == null || task._timeout != null && task._timeout != this._timeout || task._next != task) {
                throw new IllegalStateException();
            }
            Task next_next = this._next;
            this._next._prev = task;
            this._next = task;
            this._next._next = next_next;
            this._next._prev = this;
            this._next._timeout = this._timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (this._timeout != null) {
                Object object = this._timeout._mutex;
                synchronized (object) {
                    this._timestamp = 0L;
                    this.unlink();
                }
            }
        }

        public boolean isExpired() {
            return this._expired;
        }

        public boolean isScheduled() {
            return this._next != this;
        }

        public void expired() {
        }
    }
}

