/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import java.lang.reflect.Method;
import org.mortbay.log.Logger;
import org.mortbay.log.StdErrLog;
import org.mortbay.util.Loader;

public class Log {
    private static final String[] __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
    private static final Class[] __noArgs = new Class[0];
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED";
    public static final String IGNORED_FMT = "IGNORED: {}";
    public static final String NOT_IMPLEMENTED = "NOT IMPLEMENTED ";
    private static String __logClass = System.getProperty("org.mortbay.log.class", "org.mortbay.log.Slf4jLog");
    private static boolean __verbose = System.getProperty("VERBOSE", null) != null;
    private static boolean __ignored = System.getProperty("IGNORED", null) != null;
    private static Logger __log;

    public static void initialize() {
        block3: {
            Class<StdErrLog> log_class = null;
            try {
                log_class = Loader.loadClass(Log.class, __logClass);
                if (__log == null || !__log.getClass().equals(log_class)) {
                    __log = (Logger)log_class.newInstance();
                    __log.info("Logging to {} via {}", __log, log_class.getName());
                }
            }
            catch (Exception e) {
                if (__log != null) break block3;
                log_class = StdErrLog.class;
                __log = new StdErrLog();
                __log.info("Logging to {} via {}", __log, log_class.getName());
                if (!__verbose) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void setLog(Logger log) {
        __log = log;
    }

    public static Logger getLog() {
        return __log;
    }

    public static void debug(Throwable th) {
        if (__log == null || !Log.isDebugEnabled()) {
            return;
        }
        __log.debug(EXCEPTION, th);
        Log.unwind(th);
    }

    public static void debug(String msg) {
        if (__log == null) {
            return;
        }
        __log.debug(msg, null, null);
    }

    public static void debug(String msg, Object arg) {
        if (__log == null) {
            return;
        }
        __log.debug(msg, arg, null);
    }

    public static void debug(String msg, Object arg0, Object arg1) {
        if (__log == null) {
            return;
        }
        __log.debug(msg, arg0, arg1);
    }

    public static void ignore(Throwable th) {
        if (__log == null) {
            return;
        }
        if (__ignored) {
            __log.warn(IGNORED, th);
            Log.unwind(th);
        } else if (__verbose) {
            __log.warn(IGNORED, th);
            Log.unwind(th);
        }
    }

    public static void info(String msg) {
        if (__log == null) {
            return;
        }
        __log.info(msg, null, null);
    }

    public static void info(String msg, Object arg) {
        if (__log == null) {
            return;
        }
        __log.info(msg, arg, null);
    }

    public static void info(String msg, Object arg0, Object arg1) {
        if (__log == null) {
            return;
        }
        __log.info(msg, arg0, arg1);
    }

    public static boolean isDebugEnabled() {
        if (__log == null) {
            return false;
        }
        return __log.isDebugEnabled();
    }

    public static void warn(String msg) {
        if (__log == null) {
            return;
        }
        __log.warn(msg, null, null);
    }

    public static void warn(String msg, Object arg) {
        if (__log == null) {
            return;
        }
        __log.warn(msg, arg, null);
    }

    public static void warn(String msg, Object arg0, Object arg1) {
        if (__log == null) {
            return;
        }
        __log.warn(msg, arg0, arg1);
    }

    public static void warn(String msg, Throwable th) {
        if (__log == null) {
            return;
        }
        __log.warn(msg, th);
        Log.unwind(th);
    }

    public static void warn(Throwable th) {
        if (__log == null) {
            return;
        }
        __log.warn(EXCEPTION, th);
        Log.unwind(th);
    }

    public static Logger getLogger(String name) {
        if (__log == null) {
            return __log;
        }
        if (name == null) {
            return __log;
        }
        return __log.getLogger(name);
    }

    private static void unwind(Throwable th) {
        if (th == null) {
            return;
        }
        for (int i = 0; i < __nestedEx.length; ++i) {
            try {
                Method get_target = th.getClass().getMethod(__nestedEx[i], __noArgs);
                Throwable th2 = (Throwable)get_target.invoke((Object)th, (Object[])null);
                if (th2 == null || th2 == th) continue;
                Log.warn("Nested in " + th + ":", th2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        Log.initialize();
    }
}

