/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.mortbay.log.Log;

public class Scanner {
    private int _scanInterval;
    private List _listeners = Collections.synchronizedList(new ArrayList());
    private Map _prevScan = Collections.EMPTY_MAP;
    private FilenameFilter _filter;
    private List _scanDirs;
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private Timer _timer;
    private TimerTask _task;

    public int getScanInterval() {
        return this._scanInterval;
    }

    public synchronized void setScanInterval(int scanInterval) {
        if (this._running) {
            this._task.cancel();
        }
        this._scanInterval = scanInterval;
        if (this._running && this._scanInterval > 0) {
            this._timer.scheduleAtFixedRate(this._task, 1000L * (long)this.getScanInterval(), 1000L * (long)this.getScanInterval());
        }
    }

    public void setScanDir(File dir) {
        this._scanDirs = new ArrayList();
        this._scanDirs.add(dir);
    }

    public File getScanDir() {
        return this._scanDirs == null ? null : (File)this._scanDirs.get(0);
    }

    public void setScanDirs(List dirs) {
        this._scanDirs = dirs;
    }

    public List getScanDirs() {
        return this._scanDirs;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        this._reportExisting = reportExisting;
    }

    public synchronized void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (this._reportExisting) {
            this.scan();
        } else {
            this._prevScan = this.scanFiles();
        }
        this._timer = new Timer();
        this._task = new TimerTask(){

            public void run() {
                Scanner.this.scan();
            }
        };
        if (this.getScanInterval() > 0) {
            this._timer.scheduleAtFixedRate(this._task, 1000L * (long)this.getScanInterval(), 1000L * (long)this.getScanInterval());
        }
    }

    public synchronized void stop() {
        if (this._running) {
            this._running = false;
            this._task.cancel();
            this._task = null;
            this._timer = null;
        }
    }

    public void scan() {
        Map currentScan = this.scanFiles();
        this.reportDifferences(currentScan, this._prevScan);
        this._prevScan = currentScan;
    }

    public Map scanFiles() {
        if (this._scanDirs == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap scanInfo = new HashMap();
        Iterator itor = this._scanDirs.iterator();
        while (itor.hasNext()) {
            File dir = (File)itor.next();
            Log.debug("Scanning directory " + dir);
            if (dir == null || !dir.exists()) continue;
            this.scanFile(dir, scanInfo);
        }
        Log.debug("Scan complete at " + new Date());
        return scanInfo;
    }

    public void reportDifferences(Map currentScan, Map oldScan) {
        ArrayList<Object> bulkChanges = new ArrayList<Object>();
        HashSet oldScanKeys = new HashSet(oldScan.keySet());
        Iterator itor = currentScan.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            if (!oldScanKeys.contains(entry.getKey())) {
                Log.debug("File added: " + entry.getKey());
                this.reportAddition((String)entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            if (!oldScan.get(entry.getKey()).equals(entry.getValue())) {
                Log.debug("File changed: " + entry.getKey());
                this.reportChange((String)entry.getKey());
                oldScanKeys.remove(entry.getKey());
                bulkChanges.add(entry.getKey());
                continue;
            }
            oldScanKeys.remove(entry.getKey());
        }
        if (!oldScanKeys.isEmpty()) {
            Iterator keyItor = oldScanKeys.iterator();
            while (keyItor.hasNext()) {
                String filename = (String)keyItor.next();
                Log.debug("File removed: " + filename);
                this.reportRemoval(filename);
                bulkChanges.add(filename);
            }
        }
        if (!bulkChanges.isEmpty()) {
            this.reportBulkChanges(bulkChanges);
        }
    }

    private void scanFile(File f, Map scanInfoMap) {
        try {
            if (!f.exists()) {
                return;
            }
            if (f.isFile()) {
                Log.debug("Checking file " + f.getName());
                if (this._filter == null || this._filter != null && this._filter.accept(f.getParentFile(), f.getName())) {
                    Log.debug("File accepted");
                    String name = f.getCanonicalPath();
                    long lastModified = f.lastModified();
                    scanInfoMap.put(name, new Long(lastModified));
                }
            } else if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.scanFile(files[i], scanInfoMap);
                }
            }
        }
        catch (IOException e) {
            Log.warn("Error scanning watched files", e);
        }
    }

    private void reportAddition(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Object l = itor.next();
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Exception e) {
                Log.warn(e);
            }
            catch (Error e) {
                Log.warn(e);
            }
        }
    }

    private void reportRemoval(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Object l = itor.next();
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Exception e) {
                Log.warn(e);
            }
            catch (Error e) {
                Log.warn(e);
            }
        }
    }

    private void reportChange(String filename) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Object l = itor.next();
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Exception e) {
                Log.warn(e);
            }
            catch (Error e) {
                Log.warn(e);
            }
        }
    }

    private void reportBulkChanges(List filenames) {
        Iterator itor = this._listeners.iterator();
        while (itor.hasNext()) {
            try {
                Object l = itor.next();
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Exception e) {
                Log.warn(e);
            }
            catch (Error e) {
                Log.warn(e);
            }
        }
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }
}

