/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.thread;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class BoundedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private static int __id;
    private boolean _daemon;
    private int _id;
    private List _idle;
    private final String _joinLock = "JOIN";
    private long _lastShrink;
    private final String _lock = "LOCK";
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 255;
    private int _minThreads = 1;
    private String _name = "btpool" + __id++;
    private List _queue;
    private Set _threads;
    private boolean _warned = false;
    int _lowThreads = 0;
    int _priority = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable job) {
        String string = "LOCK";
        synchronized ("LOCK") {
            if (!this.isRunning() || job == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            int idle = this._idle.size();
            if (idle > 0) {
                PoolThread thread = (PoolThread)this._idle.remove(idle - 1);
                thread.dispatch(job);
            } else if (this._threads.size() < this._maxThreads) {
                this.newThread(job);
            } else {
                if (!this._warned) {
                    this._warned = true;
                    Log.debug("Out of threads for {}", this);
                }
                this._queue.add(job);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLowOnThreads() {
        BoundedThreadPool boundedThreadPool = this;
        synchronized (boundedThreadPool) {
            return this._queue.size() > this._lowThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        String string = "JOIN";
        synchronized ("JOIN") {
            while (this.isRunning()) {
                "JOIN".wait();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            while (this.isStopping()) {
                Thread.sleep(10L);
            }
            return;
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setLowThreads(int lowThreads) {
        this._lowThreads = lowThreads;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = minThreads;
        String string = "LOCK";
        synchronized ("LOCK") {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread(null);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._queue = new LinkedList();
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < 100; ++i) {
            String string = "LOCK";
            // MONITORENTER : "LOCK"
            Iterator iter = this._threads.iterator();
            while (iter.hasNext()) {
                ((Thread)iter.next()).interrupt();
            }
            // MONITOREXIT : string
            Thread.yield();
            if (this._threads.size() == 0) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        String string = "JOIN";
        // MONITORENTER : "JOIN"
        "JOIN".notifyAll();
        // MONITOREXIT : string
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoolThread newThread(Runnable job) {
        String string = "LOCK";
        synchronized ("LOCK") {
            PoolThread thread = new PoolThread(job);
            this._threads.add(thread);
            thread.setName(this._name + "-" + this._id++);
            thread.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return thread;
        }
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    static /* synthetic */ List access$100(BoundedThreadPool x0) {
        return x0._queue;
    }

    static /* synthetic */ boolean access$202(BoundedThreadPool x0, boolean x1) {
        x0._warned = x1;
        return x0._warned;
    }

    static /* synthetic */ Set access$300(BoundedThreadPool x0) {
        return x0._threads;
    }

    static /* synthetic */ int access$400(BoundedThreadPool x0) {
        return x0._maxThreads;
    }

    static /* synthetic */ List access$500(BoundedThreadPool x0) {
        return x0._idle;
    }

    static /* synthetic */ int access$600(BoundedThreadPool x0) {
        return x0._minThreads;
    }

    static /* synthetic */ long access$700(BoundedThreadPool x0) {
        return x0._lastShrink;
    }

    static /* synthetic */ long access$702(BoundedThreadPool x0, long x1) {
        x0._lastShrink = x1;
        return x0._lastShrink;
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
        }

        PoolThread(Runnable job) {
            this.setDaemon(BoundedThreadPool.this._daemon);
            this.setPriority(BoundedThreadPool.this._priority);
            this._job = job;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                if (this._job != null || job == null) {
                    throw new IllegalStateException();
                }
                this._job = job;
                this.notify();
            }
        }
    }
}

