/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.mortbay.io.Buffer;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.log.Log;

public class SslHttpChannelEndPoint
extends SelectChannelConnector.ConnectorEndPoint
implements Runnable {
    private static ByteBuffer[] __NO_BUFFERS = new ByteBuffer[0];
    private static ByteBuffer __EMPTY = ByteBuffer.allocate(0);
    private static SSLEngineResult _result;
    private SSLEngine _engine;
    private ByteBuffer _inBuffer;
    private NIOBuffer _inNIOBuffer;
    private ByteBuffer _outBuffer;
    private NIOBuffer _outNIOBuffer;
    private ByteBuffer _reuseBuffer;
    private ByteBuffer[] _outBuffers = new ByteBuffer[3];
    protected SSLSession _session;

    public SslHttpChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine) throws SSLException, IOException {
        super(channel, selectSet, key);
        this._engine = engine;
        this._engine.setUseClientMode(false);
        this._session = engine.getSession();
        this._outNIOBuffer = new NIOBuffer(this._session.getPacketBufferSize(), true);
        this._outBuffer = this._outNIOBuffer.getByteBuffer();
        this._inNIOBuffer = new NIOBuffer(this._session.getPacketBufferSize(), true);
        this._inBuffer = this._inNIOBuffer.getByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this._engine.closeOutbound();
        try {
            while (this._inBuffer.remaining() > 0) {
                switch (this._engine.getHandshakeStatus()) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return;
                    }
                    case NEED_UNWRAP: {
                        if (this.fill(__EMPTY)) break;
                        return;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        this.flush();
                        SSLEngineResult result = null;
                        try {
                            this._outBuffer.position(this._outNIOBuffer.putIndex());
                            result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                        }
                        finally {
                            this._outBuffer.position(0);
                            this._outNIOBuffer.setGetIndex(0);
                            this._outNIOBuffer.setPutIndex(result.bytesProduced());
                        }
                        this.flush();
                    }
                }
            }
            return;
        }
        finally {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int fill(Buffer buffer) throws IOException {
        ByteBuffer bbuf = this.extractInputBuffer(buffer);
        int size = buffer.length();
        try {
            this.fill(bbuf);
            while (this._inBuffer.remaining() > 0) {
                switch (this._engine.getHandshakeStatus()) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        return buffer.length() - size;
                    }
                    case NEED_UNWRAP: {
                        if (this.fill(bbuf)) break;
                        return buffer.length() - size;
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        this.flush();
                        SSLEngineResult result = null;
                        try {
                            this._outBuffer.position(this._outNIOBuffer.putIndex());
                            result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                        }
                        finally {
                            this._outBuffer.position(0);
                            this._outNIOBuffer.setGetIndex(0);
                            this._outNIOBuffer.setPutIndex(result.bytesProduced());
                        }
                        this.flush();
                    }
                }
            }
            return buffer.length() - size;
        }
        finally {
            buffer.setPutIndex(bbuf.position());
            bbuf.position(0);
        }
    }

    public int flush(Buffer buffer) throws IOException {
        return this.flush(buffer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int len2;
        if (this._outNIOBuffer.length() > 0) {
            this.flush();
            if (this._outNIOBuffer.length() > 0) {
                return 0;
            }
        }
        this._outBuffers[0] = this.extractOutputBuffer(header);
        this._outBuffers[1] = this.extractOutputBuffer(buffer);
        this._outBuffers[2] = this.extractOutputBuffer(trailer);
        try {
            this._outNIOBuffer.clear();
            this._outBuffer.position(0);
            this._outBuffer.limit(this._outBuffer.capacity());
            _result = this._engine.wrap(this._outBuffers, this._outBuffer);
            Object var5_4 = null;
            this._outBuffer.position(0);
        }
        catch (Throwable throwable) {
            int len2;
            Object var5_5 = null;
            this._outBuffer.position(0);
            this._outNIOBuffer.setGetIndex(0);
            this._outNIOBuffer.setPutIndex(_result.bytesProduced());
            int consumed = _result.bytesConsumed();
            if (consumed > 0 && header != null) {
                len2 = consumed < header.length() ? consumed : header.length();
                header.skip(len2);
                consumed -= len2;
                this._outBuffers[0].position(0);
                this._outBuffers[0].limit(this._outBuffers[0].capacity());
            }
            if (consumed > 0 && buffer != null) {
                len2 = consumed < buffer.length() ? consumed : buffer.length();
                buffer.skip(len2);
                consumed -= len2;
                this._outBuffers[1].position(0);
                this._outBuffers[1].limit(this._outBuffers[1].capacity());
            }
            if (consumed > 0 && trailer != null) {
                len2 = consumed < trailer.length() ? consumed : trailer.length();
                trailer.skip(len2);
                consumed -= len2;
                this._outBuffers[1].position(0);
                this._outBuffers[1].limit(this._outBuffers[1].capacity());
            }
            assert (consumed == 0);
            throw throwable;
        }
        this._outNIOBuffer.setGetIndex(0);
        this._outNIOBuffer.setPutIndex(_result.bytesProduced());
        int consumed = _result.bytesConsumed();
        if (consumed > 0 && header != null) {
            len2 = consumed < header.length() ? consumed : header.length();
            header.skip(len2);
            consumed -= len2;
            this._outBuffers[0].position(0);
            this._outBuffers[0].limit(this._outBuffers[0].capacity());
        }
        if (consumed > 0 && buffer != null) {
            len2 = consumed < buffer.length() ? consumed : buffer.length();
            buffer.skip(len2);
            consumed -= len2;
            this._outBuffers[1].position(0);
            this._outBuffers[1].limit(this._outBuffers[1].capacity());
        }
        if (consumed > 0 && trailer != null) {
            len2 = consumed < trailer.length() ? consumed : trailer.length();
            trailer.skip(len2);
            consumed -= len2;
            this._outBuffers[1].position(0);
            this._outBuffers[1].limit(this._outBuffers[1].capacity());
        }
        assert (consumed == 0);
        this.flush();
        return _result.bytesConsumed();
    }

    public void flush() throws IOException {
        while (this._outNIOBuffer.length() > 0) {
            int flushed = super.flush((Buffer)this._outNIOBuffer);
            if (flushed != 0) continue;
            Thread.yield();
            flushed = super.flush((Buffer)this._outNIOBuffer);
            if (flushed != 0) continue;
            return;
        }
    }

    private ByteBuffer extractInputBuffer(Buffer buffer) {
        assert (buffer instanceof NIOBuffer);
        NIOBuffer nbuf = (NIOBuffer)buffer;
        ByteBuffer bbuf = nbuf.getByteBuffer();
        bbuf.position(buffer.putIndex());
        return bbuf;
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer) {
        if (buffer == null) {
            return __EMPTY;
        }
        ByteBuffer src = null;
        NIOBuffer nBuf = null;
        if (buffer.buffer() instanceof NIOBuffer) {
            nBuf = (NIOBuffer)buffer.buffer();
            src = nBuf.getByteBuffer();
        } else {
            if (this._reuseBuffer == null) {
                this._reuseBuffer = ByteBuffer.allocateDirect(this._session.getPacketBufferSize());
            }
            this._reuseBuffer.put(buffer.asArray());
            src = this._reuseBuffer;
        }
        if (src != null) {
            src.position(buffer.getIndex());
            src.limit(buffer.putIndex());
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fill(ByteBuffer buffer) throws IOException {
        int in_len = 0;
        if (!this._inNIOBuffer.hasContent() || _result != null && _result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            int len;
            this._inNIOBuffer.clear();
            while (this._inNIOBuffer.space() > 0 && (len = super.fill((Buffer)this._inNIOBuffer)) > 0) {
                in_len += len;
            }
        }
        if (this._inNIOBuffer.length() == 0) {
            return false;
        }
        try {
            this._inBuffer.position(this._inNIOBuffer.getIndex());
            this._inBuffer.limit(this._inNIOBuffer.putIndex());
            _result = this._engine.unwrap(this._inBuffer, buffer);
            if (_result != null) {
                if (_result.getStatus() == SSLEngineResult.Status.OK) {
                    this._inNIOBuffer.skip(_result.bytesConsumed());
                } else if (_result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    throw new IOException("sslEngine closed");
                }
            }
        }
        finally {
            this._inBuffer.position(0);
            this._inBuffer.limit(this._inBuffer.capacity());
        }
        switch (_result.getStatus()) {
            case OK: 
            case CLOSED: {
                break;
            }
            case BUFFER_UNDERFLOW: {
                break;
            }
            case BUFFER_OVERFLOW: {
                buffer.clear();
                break;
            }
            default: {
                Log.warn((String)("unwrap " + _result));
                throw new IOException(_result.toString());
            }
        }
        return _result.bytesProduced() + _result.bytesConsumed() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateKey() {
        SslHttpChannelEndPoint sslHttpChannelEndPoint = this;
        synchronized (sslHttpChannelEndPoint) {
            int ops = this._key == null ? 0 : this._key.interestOps();
            this._interestOps = ops | (!this._dispatched || this._readBlocked ? 1 : 0) | (this._writable && !this._writeBlocked && !this.isBufferingOutput() ? 0 : 4);
            this._writable = true;
            if (this._interestOps != ops) {
                this._selectSet.addChange((Object)this);
                this._selectSet.wakeup();
            }
        }
    }

    public boolean isBufferingInput() {
        return this._inNIOBuffer.hasContent();
    }

    public boolean isBufferingOutput() {
        return this._outNIOBuffer.hasContent();
    }

    public boolean isBufferred() {
        return true;
    }

    public SSLEngine getSSLEngine() {
        return this._engine;
    }
}

