/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.HttpChannelEndPoint;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.ServletSSL;
import org.mortbay.jetty.security.SslHttpChannelEndPoint;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class SslSelectChannelConnector
extends SelectChannelConnector {
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    private String[] _excludeCipherSuites = null;
    private String _keystore = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _protocol = "TLS";
    private String _algorithm = "SunX509";
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm", "SunX509");
    private String _sslTrustManagerFactoryAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm", "SunX509");
    private String _truststore;
    private String _truststoreType = "JKS";

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            return null;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SslHttpChannelEndPoint sslHttpChannelEndpoint = (SslHttpChannelEndPoint)endpoint;
        SSLEngine sslEngine = sslHttpChannelEndpoint.getSSLEngine();
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSession sslSession = sslEngine.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength((String)cipherSuite));
                certs = SslSelectChannelConnector.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs);
            } else if (this._needClientAuth) {
                throw new IllegalStateException("no client auth");
            }
            request.setAttribute("javax.servlet.request.cipher_suite", (Object)cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", (Object)keySize);
        }
        catch (Exception e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
        }
    }

    public SslSelectChannelConnector() {
        Log.warn((String)"The SslSelectChannelConnector is pre-ALPHA work in progress!!!!");
        this.setHeaderBufferSize(32768);
        this.setRequestBufferSize(65536);
    }

    public String[] getCipherSuites() {
        return this._excludeCipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this._excludeCipherSuites = cipherSuites;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword((String)PASSWORD_PROPERTY, (String)password, null);
    }

    public void setTrustPassword(String password) {
        this._trustPassword = Password.getPassword((String)PASSWORD_PROPERTY, (String)password, null);
    }

    public void setKeyPassword(String password) {
        this._keyPassword = Password.getPassword((String)KEYPASSWORD_PROPERTY, (String)password, null);
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststore;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public void setProvider(String _provider) {
        this._provider = _provider;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this._secureRandomAlgorithm = algorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslKeyManagerFactoryAlgorithm = algorithm;
    }

    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslTrustManagerFactoryAlgorithm = algorithm;
    }

    public void setTruststore(String truststore) {
        this._truststore = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public HttpChannelEndPoint newHttpChannelEndPoint(SelectChannelConnector connector, SocketChannel channel, SelectChannelConnector.SelectSet selectSet, SelectionKey sKey) throws IOException {
        return new SslHttpChannelEndPoint(connector, channel, selectSet, sKey, this.createSSLEngine());
    }

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = null;
        try {
            if (this._password == null) {
                this._password = new Password("");
            }
            if (this._keyPassword == null) {
                this._keyPassword = this._password;
            }
            if (this._trustPassword == null) {
                this._trustPassword = this._password;
            }
            if (this._truststore == null) {
                this._truststore = this._keystore;
                this._truststoreType = this._keystoreType;
            }
            KeyManager[] keyManagers = null;
            if (this._keystore != null) {
                KeyStore keyStore = KeyStore.getInstance(this._keystoreType);
                if (this._password == null) {
                    throw new SSLException("_password is not set");
                }
                keyStore.load(Resource.newResource((String)this._keystore).getInputStream(), this._password.toString().toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
                if (this._keyPassword == null) {
                    throw new SSLException("_keypassword is not set");
                }
                keyManagerFactory.init(keyStore, this._keyPassword.toString().toCharArray());
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (this._truststore != null) {
                KeyStore trustStore = KeyStore.getInstance(this._truststoreType);
                trustStore.load(Resource.newResource((String)this._truststore).getInputStream(), this._trustPassword.toString().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
            SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
            context.init(keyManagers, trustManagers, secureRandom);
            engine = context.createSSLEngine();
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0) {
                List<String> excludedCSList = Arrays.asList(this._excludeCipherSuites);
                String[] enabledCipherSuites = engine.getEnabledCipherSuites();
                ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                for (String cipherName : excludedCSList) {
                    if (!enabledCSList.contains(cipherName)) continue;
                    enabledCSList.remove(cipherName);
                }
                enabledCipherSuites = enabledCSList.toArray(new String[enabledCSList.size()]);
                engine.setEnabledCipherSuites(enabledCipherSuites);
            }
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
        }
        return engine;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public static void main(String[] args) throws Exception {
        Server server = new Server();
        SslSelectChannelConnector connector = new SslSelectChannelConnector();
        connector.setKeystore("C:/jeprox/jetty_6.0/etc/keystore");
        connector.setPassword("OBF:1vny1zlo1x8e1vnw1vn61x8g1zlu1vn4");
        connector.setKeyPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
        connector.setPort(8443);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{contexts, new DefaultHandler()});
        server.setHandler((Handler)handlers);
        HashUserRealm userRealm = new HashUserRealm();
        userRealm.setName("Test Realm");
        userRealm.setConfig("C:/jeprox/jetty_6.0/etc/realm.properties");
        server.setUserRealms(new UserRealm[]{userRealm});
        WebAppContext.addWebApplications((Server)server, (String)"C:/jeprox/jetty_6.0/webapps", (String)"C:/jeprox/jetty_6.0/etc/webdefault.xml", (boolean)false, (boolean)false);
        System.setProperty("DEBUG", "true");
        server.start();
        server.join();
    }

    private class CachedInfo {
        private java.security.cert.X509Certificate[] _certs;
        private Integer _keySize;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this._keySize = keySize;
            this._certs = certs;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }
    }
}

