/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.setuid;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.setuid.SetUID;
import org.eclipse.jetty.util.log.Log;

public class SetUIDServer
extends Server {
    int _uid = 0;
    int _gid = 0;
    int _umask = 0;
    boolean _startServerAsPrivileged;

    public int getUmask() {
        return this._umask;
    }

    public void setUmask(int umask) {
        this._umask = umask;
    }

    public int getUid() {
        return this._uid;
    }

    public void setUid(int uid) {
        this._uid = uid;
    }

    public void setGid(int gid) {
        this._gid = gid;
    }

    public int getGid() {
        return this._gid;
    }

    protected void doStart() throws Exception {
        if (this._umask != 0) {
            Log.info((String)("Setting umask=0" + Integer.toString(this._umask, 8)));
            SetUID.setumask(this._umask);
        }
        if (this._startServerAsPrivileged) {
            super.doStart();
            this.dropPrivs();
        } else {
            Connector[] connectors = this.getConnectors();
            for (int i = 0; connectors != null && i < connectors.length; ++i) {
                connectors[i].open();
            }
            this.dropPrivs();
            super.doStart();
        }
    }

    private void dropPrivs() {
        int uid = SetUID.getuid();
        if (uid != 0) {
            Log.warn((String)("Expected to be running UID = 0, but got UID = " + uid));
            return;
        }
        if (this._gid != 0) {
            Log.info((String)("Setting GID=" + this._gid));
            SetUID.setgid(this._gid);
        }
        if (this._uid != 0) {
            Log.info((String)("Setting UID=" + this._uid));
            SetUID.setuid(this._uid);
        }
    }

    public boolean isStartServerAsPrivileged() {
        return this._startServerAsPrivileged;
    }

    public void setStartServerAsPrivileged(boolean startContextsAsPrivileged) {
        this._startServerAsPrivileged = startContextsAsPrivileged;
    }
}

