/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.setuid;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;

public class SetUID {
    public static final int OK = 0;
    public static final int ERROR = -1;

    public static int setumask(int umask) {
        if (Platform.isWindows()) {
            return 0;
        }
        return CLibrary.INSTANCE.umask(umask);
    }

    public static int setuid(int uid) {
        if (Platform.isWindows()) {
            return 0;
        }
        return CLibrary.INSTANCE.setuid(uid);
    }

    public static int setgid(int gid) {
        if (Platform.isWindows()) {
            return 0;
        }
        return CLibrary.INSTANCE.setgid(gid);
    }

    public static int getuid() {
        if (Platform.isWindows()) {
            return -1;
        }
        return CLibrary.INSTANCE.getuid();
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)(Platform.isWindows() ? "msvcrt" : "c"), CLibrary.class);

        public int umask(int var1);

        public int setuid(int var1);

        public int setgid(int var1);

        public int getuid();

        public int geteuid();
    }
}

