/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.MethodExpression;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.ELContextImpl;
import org.apache.jasper.runtime.ExpressionEvaluatorImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspContextWrapper;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;
import org.apache.jasper.runtime.VariableMapperImpl;
import org.apache.jasper.runtime.VariableResolverImpl;
import org.apache.jasper.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageContextImpl
extends PageContext {
    private static Logger log = Logger.getLogger(PageContextImpl.class.getName());
    private BodyContentImpl[] outs;
    private int depth;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspFactory factory;
    private boolean needsSession;
    private String errorPageURL;
    private int bufferSize;
    private JspApplicationContextImpl jspApplicationContext;
    private ELResolver elResolver;
    private ELContext elContext;
    private HashMap attributes;
    private boolean isNametableInitialized;
    private ServletRequest request;
    private ServletResponse response;
    private HttpSession session;
    private JspWriter out;
    private JspWriterImpl baseOut;

    PageContextImpl(JspFactory factory) {
        this.factory = factory;
        this.outs = new BodyContentImpl[0];
        this.attributes = new HashMap(16);
        this.depth = -1;
    }

    @Override
    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        this._initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoFlush);
    }

    private void _initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = needsSession;
        this.errorPageURL = errorPageURL;
        this.bufferSize = bufferSize;
        this.request = request;
        this.response = response;
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        this.depth = -1;
        if (this.baseOut == null) {
            this.baseOut = new JspWriterImpl(response, bufferSize, autoFlush);
        } else {
            this.baseOut.init(response, bufferSize, autoFlush);
        }
        this.out = this.baseOut;
        this.isNametableInitialized = false;
        this.setAttribute("jspx.1st.request", "true", 4);
    }

    private void initializePageScopeNameTable() {
        this.isNametableInitialized = true;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", this.request);
        this.setAttribute("javax.servlet.jsp.jspResponse", this.response);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", this.servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
    }

    @Override
    public void release() {
        this.out = this.baseOut;
        try {
            ((JspWriterImpl)this.out).flushBuffer();
        }
        catch (IOException ex) {
            log.warning("Internal error flushing the buffer in release()");
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.elContext = null;
        this.elResolver = null;
        this.jspApplicationContext = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.request = null;
        this.response = null;
        this.depth = -1;
        this.baseOut.recycle();
        this.session = null;
        this.attributes.clear();
    }

    @Override
    public Object getAttribute(final String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PageContextImpl.this.doGetAttribute(name);
                }
            });
        }
        return this.doGetAttribute(name);
    }

    private Object doGetAttribute(String name) {
        if (!this.isNametableInitialized) {
            this.initializePageScopeNameTable();
        }
        return this.attributes.get(name);
    }

    @Override
    public Object getAttribute(final String name, final int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PageContextImpl.this.doGetAttribute(name, scope);
                }
            });
        }
        return this.doGetAttribute(name, scope);
    }

    private Object doGetAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                if (!this.isNametableInitialized) {
                    this.initializePageScopeNameTable();
                }
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    @Override
    public void setAttribute(final String name, final Object attribute) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PageContextImpl.this.doSetAttribute(name, attribute);
                    return null;
                }
            });
        } else {
            this.doSetAttribute(name, attribute);
        }
    }

    private void doSetAttribute(String name, Object attribute) {
        if (attribute != null) {
            if (!this.isNametableInitialized) {
                this.initializePageScopeNameTable();
            }
            this.attributes.put(name, attribute);
        } else {
            this.removeAttribute(name, 1);
        }
    }

    @Override
    public void setAttribute(final String name, final Object o, final int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PageContextImpl.this.doSetAttribute(name, o, scope);
                    return null;
                }
            });
        } else {
            this.doSetAttribute(name, o, scope);
        }
    }

    private void doSetAttribute(String name, Object o, int scope) {
        block9: {
            block8: {
                if (o == null) break block8;
                switch (scope) {
                    case 1: {
                        if (!this.isNametableInitialized) {
                            this.initializePageScopeNameTable();
                        }
                        this.attributes.put(name, o);
                        break block9;
                    }
                    case 2: {
                        this.request.setAttribute(name, o);
                        break block9;
                    }
                    case 3: {
                        if (this.session == null) {
                            throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                        }
                        this.session.setAttribute(name, o);
                        break block9;
                    }
                    case 4: {
                        this.context.setAttribute(name, o);
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid scope");
                    }
                }
            }
            this.removeAttribute(name, scope);
        }
    }

    @Override
    public void removeAttribute(final String name, final int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PageContextImpl.this.doRemoveAttribute(name, scope);
                    return null;
                }
            });
        } else {
            this.doRemoveAttribute(name, scope);
        }
    }

    private void doRemoveAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                if (!this.isNametableInitialized) {
                    this.initializePageScopeNameTable();
                }
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
    }

    @Override
    public int getAttributesScope(final String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PageContextImpl.this.doGetAttributeScope(name);
                }
            });
        }
        return this.doGetAttributeScope(name);
    }

    private int doGetAttributeScope(String name) {
        if (!this.isNametableInitialized) {
            this.initializePageScopeNameTable();
        }
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null) {
            try {
                if (this.session.getAttribute(name) != null) {
                    return 3;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    @Override
    public Object findAttribute(final String name) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (name == null) {
                        throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
                    }
                    return PageContextImpl.this.doFindAttribute(name);
                }
            });
        }
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        return this.doFindAttribute(name);
    }

    private Object doFindAttribute(String name) {
        Object o;
        if (!this.isNametableInitialized) {
            this.initializePageScopeNameTable();
        }
        if ((o = this.attributes.get(name)) != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null) {
            try {
                o = this.session.getAttribute(name);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (o != null) {
                return o;
            }
        }
        return this.context.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNamesInScope(final int scope) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PageContextImpl.this.doGetAttributeNamesInScope(scope);
                }
            });
        }
        return this.doGetAttributeNamesInScope(scope);
    }

    private Enumeration<String> doGetAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                if (!this.isNametableInitialized) {
                    this.initializePageScopeNameTable();
                }
                return Collections.enumeration(this.attributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException(Localizer.getMessage("jsp.error.page.noSession"));
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    @Override
    public void removeAttribute(final String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PageContextImpl.this.doRemoveAttribute(name);
                    return null;
                }
            });
        } else {
            this.doRemoveAttribute(name);
        }
    }

    private void doRemoveAttribute(String name) {
        this.removeAttribute(name, 1);
        this.removeAttribute(name, 2);
        if (this.session != null) {
            try {
                this.removeAttribute(name, 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.removeAttribute(name, 4);
    }

    @Override
    public JspWriter getOut() {
        return this.out;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.config;
    }

    @Override
    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    @Override
    public ServletRequest getRequest() {
        return this.request;
    }

    @Override
    public ServletResponse getResponse() {
        return this.response;
    }

    @Override
    public Exception getException() {
        Throwable t = JspRuntimeLibrary.getThrowable(this.request);
        if (t != null && !(t instanceof Exception)) {
            t = new JspException(t);
        }
        return (Exception)t;
    }

    @Override
    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            String baseURI = uri.substring(0, uri.lastIndexOf(47));
            path = baseURI + '/' + path;
        }
        return path;
    }

    @Override
    public void include(String relativeUrlPath) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, this.out, true);
    }

    @Override
    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, this.out, flush);
    }

    @Override
    public VariableResolver getVariableResolver() {
        return new VariableResolverImpl(this);
    }

    private ELResolver getELResolver() {
        if (this.elResolver == null) {
            CompositeELResolver celResolver = new CompositeELResolver();
            celResolver.add(new ImplicitObjectELResolver());
            JspApplicationContextImpl jaContext = this.getJspApplicationContext();
            Iterator<ELResolver> it = jaContext.getELResolvers();
            while (it.hasNext()) {
                celResolver.add(it.next());
            }
            celResolver.add(new MapELResolver());
            celResolver.add(new ResourceBundleELResolver());
            celResolver.add(new ListELResolver());
            celResolver.add(new ArrayELResolver());
            celResolver.add(new BeanELResolver());
            celResolver.add(new ScopedAttributeELResolver());
            this.elResolver = celResolver;
        }
        return this.elResolver;
    }

    @Override
    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.getJspApplicationContext().createELContext(this.getELResolver());
            this.elContext.putContext(JspContext.class, this);
            ((ELContextImpl)this.elContext).setVariableMapper(new VariableMapperImpl());
        }
        return this.elContext;
    }

    JspApplicationContextImpl getJspApplicationContext() {
        if (this.jspApplicationContext == null) {
            this.jspApplicationContext = JspApplicationContextImpl.findJspApplicationContext(this.context);
        }
        return this.jspApplicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forward(String relativeUrlPath) throws ServletException, IOException {
        try {
            this.out.clear();
        }
        catch (IOException ex) {
            IllegalStateException ise = new IllegalStateException(Localizer.getMessage("jsp.error.attempt_to_clear_flushed_buffer"));
            ise.initCause(ex);
            throw ise;
        }
        while (this.response instanceof ServletResponseWrapperInclude) {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
        }
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        String includeUri = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
        ServletResponse fresponse = this.response;
        ServletRequest frequest = this.request;
        if (includeUri != null) {
            this.request.removeAttribute("javax.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(path).forward(this.request, this.response);
            Object var7_8 = null;
            if (includeUri != null) {
                this.request.setAttribute("javax.servlet.include.servlet_path", includeUri);
            }
            this.request.setAttribute("javax.servlet.forward.seen", "true");
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (includeUri != null) {
                this.request.setAttribute("javax.servlet.include.servlet_path", includeUri);
            }
            this.request.setAttribute("javax.servlet.forward.seen", "true");
            throw throwable;
        }
    }

    @Override
    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    @Override
    public JspWriter pushBody(Writer writer) {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] newOuts = new BodyContentImpl[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                newOuts[i] = this.outs[i];
            }
            newOuts[this.depth] = new BodyContentImpl(this.out);
            this.outs = newOuts;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.outs[this.depth];
    }

    @Override
    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        return new ExpressionEvaluatorImpl(this);
    }

    @Override
    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    @Override
    public void handlePageException(final Throwable t) throws IOException, ServletException {
        if (t == null) {
            throw new NullPointerException("null Throwable");
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PageContextImpl.this.doHandlePageException(t);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw (ServletException)ex;
            }
        } else {
            this.doHandlePageException(t);
        }
    }

    private void doHandlePageException(Throwable t) throws IOException, ServletException {
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("javax.servlet.jsp.jspException", t);
            this.request.setAttribute("javax.servlet.error.status_code", 500);
            this.request.setAttribute("javax.servlet.error.request_uri", ((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("javax.servlet.error.servlet_name", this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
            Object newException = this.request.getAttribute("javax.servlet.error.exception");
            if (newException != null && newException == t) {
                this.request.removeAttribute("javax.servlet.error.exception");
                this.request.setAttribute("org.glassfish.jsp.error_handled", Boolean.TRUE);
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            Throwable rootCause = null;
            if (t instanceof JspException) {
                rootCause = ((JspException)t).getRootCause();
            } else if (t instanceof ELException) {
                rootCause = t.getCause();
            }
            if (rootCause != null) {
                throw new ServletException(t.getMessage(), rootCause);
            }
            throw new ServletException(t);
        }
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.error.request_uri");
        this.request.removeAttribute("javax.servlet.jsp.jspException");
    }

    private static ExpressionFactory getExpressionFactory(PageContext pageContext) {
        PageContextImpl pc = (PageContextImpl)JspContextWrapper.getRootPageContext(pageContext);
        return pc.getJspApplicationContext().getExpressionFactory();
    }

    public static Object evaluateExpression(final String expression, final Class expectedType, final PageContext pageContext, final ProtectedFunctionMapper functionMap) throws ELException {
        Object retValue;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                retValue = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ELContextImpl elContext = (ELContextImpl)pageContext.getELContext();
                        elContext.setFunctionMapper(functionMap);
                        ExpressionFactory expFactory = PageContextImpl.getExpressionFactory(pageContext);
                        ValueExpression expr = expFactory.createValueExpression(elContext, expression, expectedType);
                        return expr.getValue(elContext);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception realEx = ex.getException();
                if (realEx instanceof ELException) {
                    throw (ELException)realEx;
                }
                throw new ELException(realEx);
            }
        } else {
            ELContextImpl elContext = (ELContextImpl)pageContext.getELContext();
            elContext.setFunctionMapper(functionMap);
            ExpressionFactory expFactory = PageContextImpl.getExpressionFactory(pageContext);
            ValueExpression expr = expFactory.createValueExpression(elContext, expression, expectedType);
            retValue = expr.getValue(elContext);
        }
        return retValue;
    }

    public static ValueExpression getValueExpression(String expression, PageContext pageContext, Class expectedType, FunctionMapper functionMap) {
        ELContextImpl elctxt = (ELContextImpl)pageContext.getELContext();
        elctxt.setFunctionMapper(functionMap);
        ExpressionFactory expFactory = PageContextImpl.getExpressionFactory(pageContext);
        return expFactory.createValueExpression(elctxt, expression, expectedType);
    }

    public static MethodExpression getMethodExpression(String expression, PageContext pageContext, FunctionMapper functionMap, Class expectedType, Class[] paramTypes) {
        ELContextImpl elctxt = (ELContextImpl)pageContext.getELContext();
        elctxt.setFunctionMapper(functionMap);
        ExpressionFactory expFactory = PageContextImpl.getExpressionFactory(pageContext);
        return expFactory.createMethodExpression(elctxt, expression, expectedType, paramTypes);
    }

    public static void setValueVariable(PageContext pageContext, String variable, ValueExpression expression) {
        ELContextImpl elctxt = (ELContextImpl)pageContext.getELContext();
        elctxt.getVariableMapper().setVariable(variable, expression);
    }

    public static void setMethodVariable(PageContext pageContext, String variable, MethodExpression expression) {
        ExpressionFactory expFactory = PageContextImpl.getExpressionFactory(pageContext);
        ValueExpression exp = expFactory.createValueExpression(expression, Object.class);
        PageContextImpl.setValueVariable(pageContext, variable, exp);
    }
}

