/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String __INCLUDE_PREFIX = "javax.servlet.include.";
    public static final String __FORWARD_PREFIX = "javax.servlet.forward.";
    public static final String __JSP_FILE = "org.apache.catalina.jsp_file";
    private final ContextHandler _contextHandler;
    private final String _uri;
    private final String _path;
    private final String _dQuery;
    private final String _named;

    public Dispatcher(ContextHandler contextHandler, String uri, String pathInContext, String query) {
        this._contextHandler = contextHandler;
        this._uri = uri;
        this._path = pathInContext;
        this._dQuery = query;
        this._named = null;
    }

    public Dispatcher(ContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._named = name;
        this._uri = null;
        this._path = null;
        this._dQuery = null;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.FORWARD);
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, DispatcherType.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        request.removeAttribute(__JSP_FILE);
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        DispatcherType old_type = baseRequest.getDispatcherType();
        Attributes old_attr = baseRequest.getAttributes();
        MultiMap<String> old_params = baseRequest.getParameters();
        try {
            baseRequest.setDispatcherType(DispatcherType.INCLUDE);
            baseRequest.getConnection().include();
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    MultiMap<String> parameters = new MultiMap<String>();
                    UrlEncoded.decodeTo(query, parameters, baseRequest.getCharacterEncoding());
                    if (old_params != null && old_params.size() > 0) {
                        for (Map.Entry<String, Object> entry : old_params.entrySet()) {
                            String name = entry.getKey();
                            Object values = entry.getValue();
                            for (int i = 0; i < LazyList.size(values); ++i) {
                                parameters.add(name, LazyList.get(values, i));
                            }
                        }
                    }
                    baseRequest.setParameters(parameters);
                }
                IncludeAttributes attr = new IncludeAttributes(old_attr);
                attr._requestURI = this._uri;
                attr._contextPath = this._contextHandler.getContextPath();
                attr._servletPath = null;
                attr._pathInfo = this._path;
                attr._query = query;
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            Object var15_14 = null;
            baseRequest.setAttributes(old_attr);
            baseRequest.getConnection().included();
            baseRequest.setParameters(old_params);
            baseRequest.setDispatcherType(old_type);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            baseRequest.setAttributes(old_attr);
            baseRequest.getConnection().included();
            baseRequest.setParameters(old_params);
            baseRequest.setDispatcherType(old_type);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forward(ServletRequest request, ServletResponse response, DispatcherType dispatch) throws ServletException, IOException {
        Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        Response base_response = baseRequest.getResponse();
        response.resetBuffer();
        base_response.fwdReset();
        request.removeAttribute(__JSP_FILE);
        if (!(request instanceof HttpServletRequest)) {
            request = new ServletRequestHttpWrapper(request);
        }
        if (!(response instanceof HttpServletResponse)) {
            response = new ServletResponseHttpWrapper(response);
        }
        String old_uri = baseRequest.getRequestURI();
        String old_context_path = baseRequest.getContextPath();
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        String old_query = baseRequest.getQueryString();
        Attributes old_attr = baseRequest.getAttributes();
        DispatcherType old_type = baseRequest.getDispatcherType();
        MultiMap<String> old_params = baseRequest.getParameters();
        try {
            baseRequest.setDispatcherType(dispatch);
            if (this._named != null) {
                this._contextHandler.handle(this._named, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String query = this._dQuery;
                if (query != null) {
                    if (old_params == null) {
                        baseRequest.extractParameters();
                        old_params = baseRequest.getParameters();
                    }
                    baseRequest.mergeQueryString(query);
                }
                ForwardAttributes attr = new ForwardAttributes(old_attr);
                if (old_attr.getAttribute(FORWARD_REQUEST_URI) != null) {
                    attr._pathInfo = (String)old_attr.getAttribute(FORWARD_PATH_INFO);
                    attr._query = (String)old_attr.getAttribute(FORWARD_QUERY_STRING);
                    attr._requestURI = (String)old_attr.getAttribute(FORWARD_REQUEST_URI);
                    attr._contextPath = (String)old_attr.getAttribute(FORWARD_CONTEXT_PATH);
                    attr._servletPath = (String)old_attr.getAttribute(FORWARD_SERVLET_PATH);
                } else {
                    attr._pathInfo = old_path_info;
                    attr._query = old_query;
                    attr._requestURI = old_uri;
                    attr._contextPath = old_context_path;
                    attr._servletPath = old_servlet_path;
                }
                baseRequest.setRequestURI(this._uri);
                baseRequest.setContextPath(this._contextHandler.getContextPath());
                baseRequest.setAttributes(attr);
                this._contextHandler.handle(this._path, baseRequest, (HttpServletRequest)request, (HttpServletResponse)response);
                if (baseRequest.getResponse().isWriting()) {
                    try {
                        response.getWriter().close();
                    }
                    catch (IllegalStateException e) {
                        response.getOutputStream().close();
                    }
                } else {
                    try {
                        response.getOutputStream().close();
                    }
                    catch (IllegalStateException e) {
                        response.getWriter().close();
                    }
                }
            }
            Object var18_18 = null;
            baseRequest.setRequestURI(old_uri);
            baseRequest.setContextPath(old_context_path);
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            baseRequest.setAttributes(old_attr);
            baseRequest.setParameters(old_params);
            baseRequest.setQueryString(old_query);
            baseRequest.setDispatcherType(old_type);
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            baseRequest.setRequestURI(old_uri);
            baseRequest.setContextPath(old_context_path);
            baseRequest.setServletPath(old_servlet_path);
            baseRequest.setPathInfo(old_path_info);
            baseRequest.setAttributes(old_attr);
            baseRequest.setParameters(old_params);
            baseRequest.setQueryString(old_query);
            baseRequest.setDispatcherType(old_type);
            throw throwable;
        }
    }

    private class IncludeAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        IncludeAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.INCLUDE_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.INCLUDE_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.INCLUDE_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.INCLUDE_QUERY_STRING)) {
                    return this._query;
                }
                if (key.equals(Dispatcher.INCLUDE_REQUEST_URI)) {
                    return this._requestURI;
                }
            } else if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add(Dispatcher.INCLUDE_PATH_INFO);
                } else {
                    set.remove(Dispatcher.INCLUDE_PATH_INFO);
                }
                set.add(Dispatcher.INCLUDE_REQUEST_URI);
                set.add(Dispatcher.INCLUDE_SERVLET_PATH);
                set.add(Dispatcher.INCLUDE_CONTEXT_PATH);
                if (this._query != null) {
                    set.add(Dispatcher.INCLUDE_QUERY_STRING);
                } else {
                    set.remove(Dispatcher.INCLUDE_QUERY_STRING);
                }
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.INCLUDE_PATH_INFO)) {
                    this._pathInfo = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_REQUEST_URI)) {
                    this._requestURI = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_SERVLET_PATH)) {
                    this._servletPath = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_CONTEXT_PATH)) {
                    this._contextPath = (String)value;
                } else if (key.equals(Dispatcher.INCLUDE_QUERY_STRING)) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "INCLUDE+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }

    private class ForwardAttributes
    implements Attributes {
        final Attributes _attr;
        String _requestURI;
        String _contextPath;
        String _servletPath;
        String _pathInfo;
        String _query;

        ForwardAttributes(Attributes attributes) {
            this._attr = attributes;
        }

        public Object getAttribute(String key) {
            if (Dispatcher.this._named == null) {
                if (key.equals(Dispatcher.FORWARD_PATH_INFO)) {
                    return this._pathInfo;
                }
                if (key.equals(Dispatcher.FORWARD_REQUEST_URI)) {
                    return this._requestURI;
                }
                if (key.equals(Dispatcher.FORWARD_SERVLET_PATH)) {
                    return this._servletPath;
                }
                if (key.equals(Dispatcher.FORWARD_CONTEXT_PATH)) {
                    return this._contextPath;
                }
                if (key.equals(Dispatcher.FORWARD_QUERY_STRING)) {
                    return this._query;
                }
            }
            if (key.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            return this._attr.getAttribute(key);
        }

        public Enumeration getAttributeNames() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._attr.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.startsWith(Dispatcher.__INCLUDE_PREFIX) || name.startsWith(Dispatcher.__FORWARD_PREFIX)) continue;
                set.add(name);
            }
            if (Dispatcher.this._named == null) {
                if (this._pathInfo != null) {
                    set.add(Dispatcher.FORWARD_PATH_INFO);
                } else {
                    set.remove(Dispatcher.FORWARD_PATH_INFO);
                }
                set.add(Dispatcher.FORWARD_REQUEST_URI);
                set.add(Dispatcher.FORWARD_SERVLET_PATH);
                set.add(Dispatcher.FORWARD_CONTEXT_PATH);
                if (this._query != null) {
                    set.add(Dispatcher.FORWARD_QUERY_STRING);
                } else {
                    set.remove(Dispatcher.FORWARD_QUERY_STRING);
                }
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String key, Object value) {
            if (Dispatcher.this._named == null && key.startsWith("javax.servlet.")) {
                if (key.equals(Dispatcher.FORWARD_PATH_INFO)) {
                    this._pathInfo = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_REQUEST_URI)) {
                    this._requestURI = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_SERVLET_PATH)) {
                    this._servletPath = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_CONTEXT_PATH)) {
                    this._contextPath = (String)value;
                } else if (key.equals(Dispatcher.FORWARD_QUERY_STRING)) {
                    this._query = (String)value;
                } else if (value == null) {
                    this._attr.removeAttribute(key);
                } else {
                    this._attr.setAttribute(key, value);
                }
            } else if (value == null) {
                this._attr.removeAttribute(key);
            } else {
                this._attr.setAttribute(key, value);
            }
        }

        public String toString() {
            return "FORWARD+" + this._attr.toString();
        }

        public void clearAttributes() {
            throw new IllegalStateException();
        }

        public void removeAttribute(String name) {
            this.setAttribute(name, null);
        }
    }
}

