/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.naming;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.mortbay.log.Log;

public class NamingUtil {
    public static void bind(Context ctx, String nameStr, Object obj) throws NamingException {
        Name name = ctx.getNameParser("").parse(nameStr);
        if (name.size() == 0) {
            return;
        }
        Context subCtx = ctx;
        for (int i = 0; i < name.size() - 1; ++i) {
            try {
                subCtx = (Context)subCtx.lookup(name.get(i));
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Subcontext " + name.get(i) + " already exists");
                continue;
            }
            catch (NameNotFoundException e) {
                subCtx = subCtx.createSubcontext(name.get(i));
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Subcontext " + name.get(i) + " created");
            }
        }
        subCtx.rebind(name.get(name.size() - 1), obj);
        if (Log.isDebugEnabled()) {
            Log.debug("Bound object to " + name.get(name.size() - 1));
        }
    }

    public static void unbind(Context ctx) throws NamingException {
        NamingEnumeration<Binding> ne = ctx.listBindings(ctx.getNameInNamespace());
        while (ne.hasMoreElements()) {
            Binding b = (Binding)ne.nextElement();
            if (b.getObject() instanceof Context) {
                NamingUtil.unbind((Context)b.getObject());
                continue;
            }
            ctx.unbind(b.getName());
        }
    }

    public static Map flattenBindings(Context ctx, String name) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Context c = (Context)ctx.lookup(name);
        NameParser parser = c.getNameParser("");
        NamingEnumeration<Binding> enm = ctx.listBindings(name);
        while (enm.hasMore()) {
            Binding b = enm.next();
            if (b.getObject() instanceof Context) {
                map.putAll(NamingUtil.flattenBindings(c, b.getName()));
                continue;
            }
            Name compoundName = parser.parse(c.getNameInNamespace());
            compoundName.add(b.getName());
            map.put(compoundName.toString(), b.getObject());
        }
        return map;
    }
}

