/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.mortbay.log.Log;

public class NamingContext
implements Context,
Cloneable {
    public static final String LOCK_PROPERTY = "org.mortbay.jndi.lock";
    public static final String UNLOCK_PROPERTY = "org.mortbay.jndi.unlock";
    public static final Enumeration EMPTY_ENUM = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    protected Context _parent = null;
    protected String _name = null;
    protected Hashtable _env = null;
    protected Hashtable _bindings = new Hashtable();
    protected NameParser _parser = null;

    public NamingContext(Hashtable env, String name, Context parent, NameParser parser) {
        this._env = env == null ? new Hashtable() : new Hashtable(env);
        this._name = name;
        this._parent = parent;
        this._parser = parser;
    }

    public NamingContext(Hashtable env) {
        this._env = env == null ? new Hashtable() : new Hashtable(env);
    }

    public NamingContext() {
        this._env = new Hashtable();
    }

    public Object clone() throws CloneNotSupportedException {
        NamingContext ctx = (NamingContext)super.clone();
        ctx._env = (Hashtable)this._env.clone();
        ctx._bindings = (Hashtable)this._bindings.clone();
        return ctx;
    }

    public String getName() {
        return this._name;
    }

    public Context getParent() {
        return this._parent;
    }

    public void setNameParser(NameParser parser) {
        this._parser = parser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind(Name name, Object obj) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding;
            Object objToBind = NamingManager.getStateToBind(obj, name, this, null);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            if ((binding = this.getBinding(cname)) != null) throw new NameAlreadyBoundException(cname.toString());
            this.addBinding(cname, objToBind);
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0));
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException(firstComponent + " is not bound");
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
        ((Context)ctx).bind(cname.getSuffix(1), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this._parser.parse(name), obj);
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (this.isLocked()) {
            NamingException ne = new NamingException("This context is immutable");
            ne.setRemainingName(name);
            throw ne;
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding != null) {
                throw new NameAlreadyBoundException(cname.toString());
            }
            NamingContext ctx = new NamingContext((Hashtable)this._env.clone(), cname.get(0), this, this._parser);
            this.addBinding(cname, ctx);
            return ctx;
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException(firstComponent + " is not bound");
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Object bound at " + firstComponent + " is a Reference");
                }
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (ctx instanceof Context) {
            return ((Context)ctx).createSubcontext(cname.getSuffix(1));
        }
        throw new NotContextException(firstComponent + " is not a Context");
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this._parser.parse(name));
    }

    public void destroySubcontext(String name) throws NamingException {
        this.removeBinding(this._parser.parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.removeBinding(name);
    }

    public Object lookup(Name name) throws NamingException {
        Name cname;
        if (Log.isDebugEnabled()) {
            Log.debug("Looking up name=\"" + name + "\"");
        }
        if ((cname = this.toCanonicalName(name)) == null || cname.size() == 0) {
            Log.debug("Null or empty name, returning copy of this context");
            NamingContext ctx = new NamingContext(this._env, this._name, this._parent, this._parser);
            ctx._bindings = this._bindings;
            return ctx;
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding == null) {
                NameNotFoundException nnfe = new NameNotFoundException();
                nnfe.setRemainingName(cname);
                throw nnfe;
            }
            Object o = binding.getObject();
            if (o instanceof LinkRef) {
                String linkName = ((LinkRef)o).getLinkName();
                if (linkName.startsWith("./")) {
                    return this.lookup(linkName.substring(2));
                }
                InitialContext ictx = new InitialContext();
                return ictx.lookup(linkName);
            }
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname, this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
            return o;
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                NameNotFoundException nnfe = new NameNotFoundException();
                nnfe.setRemainingName(cname);
                throw nnfe;
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).lookup(cname.getSuffix(1));
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this._parser.parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            NamingContext ctx = new NamingContext(this._env, this._name, this._parent, this._parser);
            ctx._bindings = this._bindings;
            return ctx;
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            Object o = binding.getObject();
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname.getPrefix(1), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
            return o;
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).lookup(cname.getSuffix(1));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this._parser.parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Name cname;
        if (Log.isDebugEnabled()) {
            Log.debug("list() on Context=" + this.getName() + " for name=" + name);
        }
        if ((cname = this.toCanonicalName(name)) == null) {
            return new NameEnumeration(EMPTY_ENUM);
        }
        if (cname.size() == 0) {
            return new NameEnumeration(this._bindings.elements());
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                if (Log.isDebugEnabled()) {
                    Log.debug("Dereferencing Reference for " + name.get(0));
                }
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).list(cname.getSuffix(1));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this._parser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            return new BindingEnumeration(EMPTY_ENUM);
        }
        if (cname.size() == 0) {
            return new BindingEnumeration(this._bindings.elements());
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    Log.warn("", e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).listBindings(cname.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this._parser.parse(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, this, null);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            this.addBinding(cname, objToBind);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0));
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = this.getBinding(name.get(0));
                if (binding == null) {
                    throw new NameNotFoundException(name.get(0) + " is not bound");
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (ctx instanceof Context) {
                ((Context)ctx).rebind(cname.getSuffix(1), obj);
            } else {
                throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
            }
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this._parser.parse(name), obj);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this._parser.parse(name));
    }

    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            return;
        }
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            this.removeBinding(cname);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0));
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = this.getBinding(name.get(0));
                if (binding == null) {
                    throw new NameNotFoundException(name.get(0) + " is not bound");
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (ctx instanceof Context) {
                ((Context)ctx).unbind(cname.getSuffix(1));
            } else {
                throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
            }
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null) {
            throw new NamingException("Name cannot be null");
        }
        if (prefix == null) {
            throw new NamingException("Prefix cannot be null");
        }
        CompoundName compoundName = (CompoundName)prefix.clone();
        compoundName.addAll(name);
        return compoundName;
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (name == null) {
            throw new NamingException("Name cannot be null");
        }
        if (prefix == null) {
            throw new NamingException("Prefix cannot be null");
        }
        Name compoundName = this._parser.parse(prefix);
        compoundName.add(name);
        return compoundName.toString();
    }

    public void close() throws NamingException {
    }

    public NameParser getNameParser(Name name) {
        return this._parser;
    }

    public NameParser getNameParser(String name) {
        return this._parser;
    }

    public String getNameInNamespace() throws NamingException {
        Name name = this._parser.parse("");
        for (NamingContext c = this; c != null; c = (NamingContext)c.getParent()) {
            String str = c.getName();
            if (str == null) continue;
            name.add(0, str);
        }
        return name.toString();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.isLocked() && !propName.equals(UNLOCK_PROPERTY)) {
            throw new NamingException("This context is immutable");
        }
        return this._env.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        return this._env.remove(propName);
    }

    public Hashtable getEnvironment() {
        return (Hashtable)this._env.clone();
    }

    protected void addBinding(Name name, Object obj) {
        String key = name.toString();
        if (Log.isDebugEnabled()) {
            Log.debug("Adding binding with key=" + key + " obj=" + obj + " for context=" + this._name);
        }
        this._bindings.put(key, new Binding(key, obj));
    }

    protected Binding getBinding(Name name) {
        if (Log.isDebugEnabled()) {
            Log.debug("Looking up binding for " + name.toString() + " for context=" + this._name);
        }
        return (Binding)this._bindings.get(name.toString());
    }

    protected Binding getBinding(String name) {
        if (Log.isDebugEnabled()) {
            Log.debug("Looking up binding for " + name + " for context=" + this._name);
        }
        return (Binding)this._bindings.get(name);
    }

    protected void removeBinding(Name name) {
        String key = name.toString();
        if (Log.isDebugEnabled()) {
            Log.debug("Removing binding with key=" + key);
        }
        this._bindings.remove(key);
    }

    public Name toCanonicalName(Name name) {
        Name canonicalName = name;
        if (name != null && canonicalName.size() > 1) {
            if (canonicalName.get(0).equals("")) {
                canonicalName = canonicalName.getSuffix(1);
            }
            if (canonicalName.get(canonicalName.size() - 1).equals("")) {
                canonicalName = canonicalName.getPrefix(canonicalName.size() - 1);
            }
        }
        return canonicalName;
    }

    private boolean isLocked() {
        if (this._env.get(LOCK_PROPERTY) == null && this._env.get(UNLOCK_PROPERTY) == null) {
            return false;
        }
        Object lockKey = this._env.get(LOCK_PROPERTY);
        Object unlockKey = this._env.get(UNLOCK_PROPERTY);
        return lockKey == null || unlockKey == null || !lockKey.equals(unlockKey);
    }

    public class BindingEnumeration
    implements NamingEnumeration {
        Enumeration _delegate;

        public BindingEnumeration(Enumeration e) {
            this._delegate = e;
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this._delegate.hasMoreElements();
        }

        public Object next() throws NamingException {
            Binding b = (Binding)this._delegate.nextElement();
            return new Binding(b.getName(), b.getClassName(), b.getObject(), true);
        }

        public boolean hasMoreElements() {
            return this._delegate.hasMoreElements();
        }

        public Object nextElement() {
            Binding b = (Binding)this._delegate.nextElement();
            return new Binding(b.getName(), b.getClassName(), b.getObject(), true);
        }
    }

    public class NameEnumeration
    implements NamingEnumeration {
        Enumeration _delegate;

        public NameEnumeration(Enumeration e) {
            this._delegate = e;
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this._delegate.hasMoreElements();
        }

        public Object next() throws NamingException {
            Binding b = (Binding)this._delegate.nextElement();
            return new NameClassPair(b.getName(), b.getClassName(), true);
        }

        public boolean hasMoreElements() {
            return this._delegate.hasMoreElements();
        }

        public Object nextElement() {
            Binding b = (Binding)this._delegate.nextElement();
            return new NameClassPair(b.getName(), b.getClassName(), true);
        }
    }
}

