/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.JarScanner;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.xml.XmlParser;

public class WebXmlConfiguration
implements Configuration {
    protected WebAppContext _context;
    protected XmlParser _xmlParser = WebXmlConfiguration.webXmlParser();
    protected Object _filters;
    protected Object _filterMappings;
    protected Object _servlets;
    protected Object _servletMappings;
    protected Object _welcomeFiles;
    protected Object _constraintMappings;
    protected Object _listeners;
    protected Map _errorPages;
    protected boolean _hasJSP;
    protected String _jspServletName;
    protected String _jspServletClass;
    protected boolean _defaultWelcomeFileList;
    protected ServletHandler _servletHandler;
    protected int _version;
    protected boolean _metaDataComplete = false;
    private URL _webxml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlParser webXmlParser() throws ClassNotFoundException {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_2.dtd", true);
        URL dtd23 = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_3.dtd", true);
        URL j2ee14xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_1_4.xsd", true);
        URL webapp24xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_4.xsd", true);
        URL webapp25xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_2_5.xsd", true);
        URL webapp30xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/web-app_3_0.xsd", true);
        URL schemadtd = Loader.getResource(Servlet.class, "javax/servlet/resources/XMLSchema.dtd", true);
        URL xmlxsd = Loader.getResource(Servlet.class, "javax/servlet/resources/xml.xsd", true);
        URL webservice11xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/j2ee_web_services_client_1_1.xsd", true);
        URL webservice12xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/javaee_web_services_client_1_2.xsd", true);
        URL datatypesdtd = Loader.getResource(Servlet.class, "javax/servlet/resources/datatypes.dtd", true);
        URL jsp20xsd = null;
        URL jsp21xsd = null;
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
            jsp20xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_0.xsd");
            jsp21xsd = jsp_page.getResource("/javax/servlet/resources/jsp_2_1.xsd");
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        finally {
            if (jsp20xsd == null) {
                jsp20xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_0.xsd", true);
            }
            if (jsp21xsd == null) {
                jsp21xsd = Loader.getResource(Servlet.class, "javax/servlet/resources/jsp_2_1.xsd", true);
            }
        }
        WebXmlConfiguration.redirect(xmlParser, "web-app_2_2.dtd", dtd22);
        WebXmlConfiguration.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        WebXmlConfiguration.redirect(xmlParser, "web.dtd", dtd23);
        WebXmlConfiguration.redirect(xmlParser, "web-app_2_3.dtd", dtd23);
        WebXmlConfiguration.redirect(xmlParser, "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        WebXmlConfiguration.redirect(xmlParser, "XMLSchema.dtd", schemadtd);
        WebXmlConfiguration.redirect(xmlParser, "http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        WebXmlConfiguration.redirect(xmlParser, "-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        WebXmlConfiguration.redirect(xmlParser, "jsp_2_0.xsd", jsp20xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        WebXmlConfiguration.redirect(xmlParser, "jsp_2_1.xsd", jsp21xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        WebXmlConfiguration.redirect(xmlParser, "j2ee_1_4.xsd", j2ee14xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        WebXmlConfiguration.redirect(xmlParser, "web-app_2_4.xsd", webapp24xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        WebXmlConfiguration.redirect(xmlParser, "web-app_2_5.xsd", webapp25xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        WebXmlConfiguration.redirect(xmlParser, "web-app_3_0.xsd", webapp30xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", webapp30xsd);
        WebXmlConfiguration.redirect(xmlParser, "xml.xsd", xmlxsd);
        WebXmlConfiguration.redirect(xmlParser, "http://www.w3.org/2001/xml.xsd", xmlxsd);
        WebXmlConfiguration.redirect(xmlParser, "datatypes.dtd", datatypesdtd);
        WebXmlConfiguration.redirect(xmlParser, "http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        WebXmlConfiguration.redirect(xmlParser, "j2ee_web_services_client_1_1.xsd", webservice11xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        WebXmlConfiguration.redirect(xmlParser, "javaee_web_services_client_1_2.xsd", webservice12xsd);
        WebXmlConfiguration.redirect(xmlParser, "http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        return xmlParser;
    }

    private static void redirect(XmlParser parser, String resource, URL source) {
        if (source != null) {
            parser.redirectEntity(resource, source);
        }
    }

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        String defaultsDescriptor = this.getWebAppContext().getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = this._context.newResource(defaultsDescriptor);
            }
            XmlParser.Node config = null;
            config = this._xmlParser.parse(dftResource.getURL().toString());
            this.initialize(config);
            this._defaultWelcomeFileList = this._welcomeFiles != null;
        }
    }

    public void configureWebApp() throws Exception {
        String overrideDescriptor;
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug("Cannot configure webapp after it is started");
            }
            return;
        }
        this._webxml = this.findWebXml();
        if (this._webxml != null) {
            this.configure(this._webxml.toString());
        }
        if ((overrideDescriptor = this.getWebAppContext().getOverrideDescriptor()) != null && overrideDescriptor.length() > 0) {
            Resource orideResource = Resource.newSystemResource(overrideDescriptor);
            if (orideResource == null) {
                orideResource = this._context.newResource(overrideDescriptor);
            }
            this._xmlParser.setValidating(false);
            this.configure(orideResource.getURL().toString());
        }
        this.configureWebFragments();
    }

    public void configureWebFragments() throws Exception {
        Log.debug("metadata-complete " + this._metaDataComplete);
        if (this._metaDataComplete) {
            return;
        }
        String tmp = this._context.getInitParameter("org.mortbay.jetty.webapp.WebXmlFragmentPattern");
        Pattern webFragPattern = tmp == null ? null : Pattern.compile(tmp);
        JarScanner fragScanner = new JarScanner(){

            public void processEntry(URL jarUrl, JarEntry entry) {
                try {
                    String name = entry.getName();
                    if (name.toLowerCase().equals("meta-inf/web.xml")) {
                        Resource webXmlFrag = this._context.newResource("jar:" + jarUrl + "!/" + name);
                        Log.debug("web.xml fragment found {}", webXmlFrag);
                        XmlParser.Node config = null;
                        config = WebXmlConfiguration.this._xmlParser.parse(webXmlFrag.toString());
                        WebXmlConfiguration.this.initialize(config);
                    }
                }
                catch (Exception e) {
                    Log.warn("Problem processing jar entry " + entry, e);
                }
            }
        };
        fragScanner.setWebAppContext(this._context);
        fragScanner.scan(webFragPattern, Thread.currentThread().getContextClassLoader(), true, false);
    }

    protected URL findWebXml() throws IOException, MalformedURLException {
        Resource web;
        String descriptor = this.getWebAppContext().getDescriptor();
        if (descriptor != null && (web = this._context.newResource(descriptor)).exists() && !web.isDirectory()) {
            return web.getURL();
        }
        Resource web_inf = this.getWebAppContext().getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource web2 = web_inf.addPath("web.xml");
            if (web2.exists()) {
                return web2.getURL();
            }
            Log.debug("No WEB-INF/web.xml in " + this.getWebAppContext().getWar() + ". Serving files and default/dynamic servlets only");
        }
        return null;
    }

    public void configure(String webXml) throws Exception {
        XmlParser.Node config = null;
        config = this._xmlParser.parse(webXml);
        this.initializeVersion(config);
        this.initialize(config);
    }

    public void deconfigureWebApp() throws Exception {
        this._servletHandler = this.getWebAppContext().getServletHandler();
        this._servletHandler.setFilters(null);
        this._servletHandler.setFilterMappings(null);
        this._servletHandler.setServlets(null);
        this._servletHandler.setServletMappings(null);
        this.getWebAppContext().setEventListeners(null);
        this.getWebAppContext().setWelcomeFiles(null);
        if (this.getWebAppContext().getSecurityHandler() != null) {
            this.getWebAppContext().getSecurityHandler().setConstraintMappings(null);
        }
        if (this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(null);
        }
    }

    protected void initializeVersion(XmlParser.Node config) {
        String version = config.getAttribute("version", "DTD");
        if ("2.5".equals(version)) {
            this._version = 25;
        } else if ("2.4".equals(version)) {
            this._version = 24;
        } else if ("3.0".equals(version)) {
            this._version = 30;
        } else if ("DTD".equals(version)) {
            this._version = 23;
            String dtd = this._xmlParser.getDTD();
            if (dtd != null && dtd.indexOf("web-app_2_2") >= 0) {
                this._version = 22;
            }
        }
        this._metaDataComplete = this._version < 25 ? true : Boolean.valueOf(config.getAttribute("metadata-complete", "false"));
        Log.debug("Calculated metadatacomplete = " + this._metaDataComplete + " with version=" + version);
        this._context.setAttribute("metadata-complete", String.valueOf(this._metaDataComplete));
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        this._servletHandler = this.getWebAppContext().getServletHandler();
        this._filters = LazyList.array2List(this._servletHandler.getFilters());
        this._filterMappings = LazyList.array2List(this._servletHandler.getFilterMappings());
        this._servlets = LazyList.array2List(this._servletHandler.getServlets());
        this._servletMappings = LazyList.array2List(this._servletHandler.getServletMappings());
        this._listeners = LazyList.array2List(this.getWebAppContext().getEventListeners());
        this._welcomeFiles = LazyList.array2List(this.getWebAppContext().getWelcomeFiles());
        this._constraintMappings = LazyList.array2List(this.getWebAppContext().getSecurityHandler().getConstraintMappings());
        this._errorPages = this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler ? ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).getErrorPages() : null;
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                Log.warn("Configuration problem at " + node, e);
                throw new UnavailableException("Configuration problem");
            }
        }
        this._servletHandler.setFilters((FilterHolder[])LazyList.toArray(this._filters, FilterHolder.class));
        this._servletHandler.setFilterMappings((FilterMapping[])LazyList.toArray(this._filterMappings, FilterMapping.class));
        this._servletHandler.setServlets((ServletHolder[])LazyList.toArray(this._servlets, ServletHolder.class));
        this._servletHandler.setServletMappings((ServletMapping[])LazyList.toArray(this._servletMappings, ServletMapping.class));
        this.getWebAppContext().setEventListeners((EventListener[])LazyList.toArray(this._listeners, EventListener.class));
        this.getWebAppContext().setWelcomeFiles((String[])LazyList.toArray(this._welcomeFiles, String.class));
        this.getWebAppContext().getSecurityHandler().setConstraintMappings((ConstraintMapping[])LazyList.toArray(this._constraintMappings, ConstraintMapping.class));
        if (this._errorPages != null && this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(this._errorPages);
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(element)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(element)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(element)) {
                if (Log.isDebugEnabled()) {
                    Log.debug("No implementation: " + node);
                }
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else if ("distributable".equals(element)) {
                this.initDistributable(node);
            } else if (!"web-fragment".equals(element) && Log.isDebugEnabled()) {
                Log.debug("Element {} not handled in {}", element, this);
                Log.debug(node.toString());
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebAppContext().setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        if (Log.isDebugEnabled()) {
            Log.debug("ContextParam: " + name + "=" + value);
        }
        this.getWebAppContext().getInitParams().put(name, value);
    }

    protected void initFilter(XmlParser.Node node) {
        String filter_class;
        String name = node.getString("filter-name", false, true);
        FilterHolder holder = this._servletHandler.getFilter(name);
        if (holder == null) {
            holder = this._servletHandler.newFilterHolder();
            holder.setName(name);
            this._filters = LazyList.add(this._filters, holder);
        }
        if ((filter_class = node.getString("filter-class", false, true)) != null) {
            holder.setClassName(filter_class);
        }
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
    }

    protected void initFilterMapping(XmlParser.Node node) {
        String filter_name = node.getString("filter-name", false, true);
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filter_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        ArrayList<String> names = new ArrayList<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = ((XmlParser.Node)iter.next()).toString(false, true);
            names.add(n);
        }
        mapping.setServletNames(names.toArray(new String[names.size()]));
        int dispatcher = 0;
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatcher |= Dispatcher.type(d);
        }
        mapping.setDispatches(dispatcher);
        iter = node.iterator("life-cycle");
        while (iter.hasNext()) {
            String l = ((XmlParser.Node)iter.next()).toString(false, true);
            if ("initial".equalsIgnoreCase(l)) {
                mapping.setInitialLifeCycle(true);
            }
            if (!"redispatch".equalsIgnoreCase(l)) continue;
            mapping.setRedispatchLifeCycle(true);
        }
        mapping.setDispatches(dispatcher);
        this._filterMappings = LazyList.add(this._filterMappings, mapping);
    }

    protected String normalizePattern(String p) {
        if (p != null && p.length() > 0 && !p.startsWith("/") && !p.startsWith("*")) {
            return "/" + p;
        }
        return p;
    }

    protected void initServlet(XmlParser.Node node) {
        String roleName;
        XmlParser.Node startup;
        String jsp_file;
        String id = node.getAttribute("id");
        String servlet_name = node.getString("servlet-name", false, true);
        ServletHolder holder = this._servletHandler.getServlet(servlet_name);
        if (holder == null) {
            holder = this._servletHandler.newServletHolder();
            holder.setName(servlet_name);
            this._servlets = LazyList.add(this._servlets, holder);
        }
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        String servlet_class = node.getString("servlet-class", false, true);
        if (id != null && id.equals("jsp")) {
            this._jspServletName = servlet_name;
            this._jspServletClass = servlet_class;
            try {
                Loader.loadClass(this.getClass(), servlet_class);
                this._hasJSP = true;
            }
            catch (ClassNotFoundException e) {
                Log.info("NO JSP Support for {}, did not find {}", this._context.getContextPath(), servlet_class);
                this._hasJSP = false;
                servlet_class = "org.mortbay.jetty.servlet.NoJspServlet";
                this._jspServletClass = "org.mortbay.jetty.servlet.NoJspServlet";
            }
            if (holder.getInitParameter("scratchdir") == null) {
                File tmp = this.getWebAppContext().getTempDirectory();
                File scratch = new File(tmp, "jsp");
                if (!scratch.exists()) {
                    scratch.mkdir();
                }
                holder.setInitParameter("scratchdir", scratch.getAbsolutePath());
                if ("?".equals(holder.getInitParameter("classpath"))) {
                    String classpath = this.getWebAppContext().getClassPath();
                    Log.debug("classpath=" + classpath);
                    if (classpath != null) {
                        holder.setInitParameter("classpath", classpath);
                    }
                }
            }
        }
        if (servlet_class != null) {
            holder.setClassName(servlet_class);
        }
        if ((jsp_file = node.getString("jsp-file", false, true)) != null) {
            holder.setForcedPath(jsp_file);
            holder.setClassName(this._jspServletClass);
        }
        if ((startup = node.get("load-on-startup")) != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                Log.warn("Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Log.warn("Cannot parse load-on-startup " + s + ". Please use integer");
                    Log.ignore(e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (Log.isDebugEnabled()) {
                    Log.debug("link role " + roleName + " to " + roleLink + " for " + this);
                }
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            Log.warn("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAs(roleName);
        }
    }

    protected void initServletMapping(XmlParser.Node node) {
        String servlet_name = node.getString("servlet-name", false, true);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(servlet_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        this._servletMappings = LazyList.add(this._servletMappings, mapping);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            Class listenerClass = this.getWebAppContext().loadClass(className);
            listener = this.newListenerInstance(listenerClass);
            if (!(listener instanceof EventListener)) {
                Log.warn("Not an EventListener: " + listener);
                return;
            }
            this._listeners = LazyList.add(this._listeners, listener);
        }
        catch (Exception e) {
            Log.warn("Could not instantiate listener " + className, e);
            return;
        }
    }

    protected Object newListenerInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    protected void initDistributable(XmlParser.Node node) {
        WebAppContext wac = this.getWebAppContext();
        if (!wac.isDistributable()) {
            wac.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this.getWebAppContext().getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.getWebAppContext().getMimeTypes().addMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        if (this._defaultWelcomeFileList) {
            this._welcomeFiles = null;
        }
        this._defaultWelcomeFileList = false;
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            this._welcomeFiles = LazyList.add(this._welcomeFiles, welcome);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            this.getWebAppContext().addLocaleEncoding(locale, encoding);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(error, location);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this.getWebAppContext().setResourceAlias(uri, location);
    }

    protected void initJspConfig(XmlParser.Node node) {
        String jspName;
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.initTagLib((XmlParser.Node)o);
        }
        Iterator iter = node.iterator("jsp-property-group");
        Object paths = null;
        while (iter.hasNext()) {
            XmlParser.Node group = (XmlParser.Node)iter.next();
            Iterator iter2 = group.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                url = this.normalizePattern(url);
                paths = LazyList.add(paths, url);
            }
        }
        if (LazyList.size(paths) > 0 && (jspName = this.getJSPServletName()) != null) {
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(jspName);
            mapping.setPathSpecs(LazyList.toStringArray(paths));
            this._servletMappings = LazyList.add(this._servletMappings, mapping);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        Constraint scBase = new Constraint();
        try {
            XmlParser.Node data;
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                Object roles = null;
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    roles = LazyList.add(roles, role);
                }
                scBase.setRoles(LazyList.toStringArray(roles));
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    Log.warn("Unknown user-data-constraint:" + guarantee);
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                Constraint sc = (Constraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    url = this.normalizePattern(url);
                    Iterator iter3 = collection.iterator("http-method");
                    if (iter3.hasNext()) {
                        while (iter3.hasNext()) {
                            String method = ((XmlParser.Node)iter3.next()).toString(false, true);
                            ConstraintMapping mapping = new ConstraintMapping();
                            mapping.setMethod(method);
                            mapping.setPathSpec(url);
                            mapping.setConstraint(sc);
                            this._constraintMappings = LazyList.add(this._constraintMappings, mapping);
                        }
                        continue;
                    }
                    ConstraintMapping mapping = new ConstraintMapping();
                    mapping.setPathSpec(url);
                    mapping.setConstraint(sc);
                    this._constraintMappings = LazyList.add(this._constraintMappings, mapping);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            Log.warn(e);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) throws Exception {
        XmlParser.Node method = node.get("auth-method");
        FormAuthenticator _formAuthenticator = null;
        if (method != null) {
            Authenticator authenticator = null;
            String m = method.toString(false, true);
            if ("FORM".equals(m)) {
                authenticator = _formAuthenticator = new FormAuthenticator();
            } else if ("BASIC".equals(m)) {
                authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(m)) {
                authenticator = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equals(m) || "CLIENT-CERT".equals(m)) {
                authenticator = (Authenticator)Loader.loadClass(WebXmlConfiguration.class, "org.mortbay.jetty.security.ClientCertAuthenticator").newInstance();
            } else {
                Log.warn("UNKNOWN AUTH METHOD: " + m);
            }
            this.getWebAppContext().getSecurityHandler().setAuthenticator(authenticator);
        }
        XmlParser.Node name = node.get("realm-name");
        UserRealm[] realms = ContextHandler.getCurrentContext().getContextHandler().getServer().getUserRealms();
        String realm_name = name == null ? "default" : name.toString(false, true);
        UserRealm realm = this.getWebAppContext().getSecurityHandler().getUserRealm();
        for (int i = 0; realm == null && realms != null && i < realms.length; ++i) {
            if (realms[i] == null || !realm_name.equals(realms[i].getName())) continue;
            realm = realms[i];
        }
        if (realm == null) {
            String msg = "Unknown realm: " + realm_name;
            Log.warn(msg);
        } else {
            this.getWebAppContext().getSecurityHandler().setUserRealm(realm);
        }
        XmlParser.Node formConfig = node.get("form-login-config");
        if (formConfig != null) {
            if (_formAuthenticator == null) {
                Log.warn("FORM Authentication miss-configured");
            } else {
                XmlParser.Node errorPage;
                XmlParser.Node loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    _formAuthenticator.setLoginPage(loginPage.toString(false, true));
                }
                if ((errorPage = formConfig.get("form-error-page")) != null) {
                    String ep = errorPage.toString(false, true);
                    _formAuthenticator.setErrorPage(ep);
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    protected String getJSPServletName() {
        PathMap.Entry entry;
        if (this._jspServletName == null && (entry = this._context.getServletHandler().getHolderEntry("test.jsp")) != null) {
            ServletHolder holder = (ServletHolder)entry.getValue();
            this._jspServletName = holder.getName();
        }
        return this._jspServletName;
    }
}

