/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;

public abstract class JarScanner {
    WebAppContext _context;

    public abstract void processEntry(URL var1, JarEntry var2);

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void scan(Pattern pattern, ClassLoader loader, boolean isNullInclusive, boolean visitParent) throws Exception {
        String[] patterns = pattern == null ? null : pattern.pattern().split(",");
        ArrayList<Pattern> subPatterns = new ArrayList<Pattern>();
        for (int i = 0; patterns != null && i < patterns.length; ++i) {
            subPatterns.add(Pattern.compile(patterns[i]));
        }
        while (loader != null) {
            URL[] urls;
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                if (subPatterns.isEmpty()) {
                    this.processJars(null, urls, isNullInclusive);
                } else {
                    for (Pattern p : subPatterns) {
                        this.processJars(p, urls, isNullInclusive);
                    }
                }
            }
            if (visitParent) {
                loader = loader.getParent();
                continue;
            }
            loader = null;
        }
    }

    public void processJars(Pattern pattern, URL[] urls, boolean isNullInclusive) throws Exception {
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().toLowerCase().endsWith(".jar")) continue;
            String jar = urls[i].toString();
            int slash = jar.lastIndexOf(47);
            jar = jar.substring(slash + 1);
            if ((pattern != null || !isNullInclusive) && (pattern == null || !pattern.matcher(jar).matches())) continue;
            this.processJar(urls[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJar(URL url) throws Exception {
        Log.debug("Search of {}", url);
        InputStream in = this._context.newResource(url).getInputStream();
        if (in == null) {
            return;
        }
        JarInputStream jar_in = new JarInputStream(in);
        try {
            JarEntry entry = jar_in.getNextJarEntry();
            while (entry != null) {
                this.processEntry(url, entry);
                entry = jar_in.getNextJarEntry();
            }
        }
        finally {
            jar_in.close();
        }
    }
}

