/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Arrays;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.PathMap;

public class FilterMapping {
    private int _dispatches = 1;
    private String _filterName;
    private transient FilterHolder _holder;
    private String[] _pathSpecs;
    private String[] _servletNames;
    private boolean _redispatch;
    private boolean _initial;

    boolean appliesTo(String path, int type, boolean initial) {
        if ((this._initial == this._redispatch || this._initial && initial || this._redispatch && !initial) && ((this._dispatches & type) != 0 || this._dispatches == 0 && type == 1) && this._pathSpecs != null) {
            for (int i = 0; i < this._pathSpecs.length; ++i) {
                if (this._pathSpecs[i] == null || !PathMap.match(this._pathSpecs[i], path, true)) continue;
                return true;
            }
        }
        return false;
    }

    boolean appliesTo(int type, boolean initial) {
        return (this._initial == this._redispatch || this._initial && initial || this._redispatch && !initial) && ((this._dispatches & type) != 0 || this._dispatches == 0 && type == 1);
    }

    public int getDispatches() {
        return this._dispatches;
    }

    public String getFilterName() {
        return this._filterName;
    }

    FilterHolder getFilterHolder() {
        return this._holder;
    }

    public String[] getPathSpecs() {
        return this._pathSpecs;
    }

    public void setDispatches(int dispatches) {
        this._dispatches = dispatches;
    }

    public void setFilterName(String filterName) {
        this._filterName = filterName;
    }

    void setFilterHolder(FilterHolder holder) {
        this._holder = holder;
    }

    public void setPathSpecs(String[] pathSpecs) {
        this._pathSpecs = pathSpecs;
    }

    public void setPathSpec(String pathSpec) {
        this._pathSpecs = new String[]{pathSpec};
    }

    public String[] getServletNames() {
        return this._servletNames;
    }

    public void setServletNames(String[] servletNames) {
        this._servletNames = servletNames;
    }

    public void setServletName(String servletName) {
        this._servletNames = new String[]{servletName};
    }

    public String toString() {
        return "(F=" + this._filterName + "," + (this._pathSpecs == null ? "[]" : Arrays.asList(this._pathSpecs).toString()) + "," + (this._servletNames == null ? "[]" : Arrays.asList(this._servletNames).toString()) + "," + this._dispatches + ")";
    }

    public boolean isRedispatchLifeCycle() {
        return this._redispatch;
    }

    public void setRedispatchLifeCycle(boolean redispatch) {
        this._redispatch = redispatch;
    }

    public boolean isInitialLifeCycle() {
        return this._initial;
    }

    public void setInitialLifeCycle(boolean initial) {
        this._initial = initial;
    }
}

