/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.jetty.plus.webapp.AbstractConfiguration;
import org.mortbay.log.Log;

public class Configuration
extends AbstractConfiguration {
    private Integer _key;

    public void bindEnvEntry(String name, Object value) throws Exception {
        EnvEntry.bindToENC(name, value);
    }

    public void bindResourceRef(String name, Class typeClass) throws Exception {
        block2: {
            try {
                String mappedName = NamingEntryUtil.getMappedName(name);
                NamingEntryUtil.bindToENC(name, mappedName);
            }
            catch (NameNotFoundException e) {
                NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(typeClass.getName() + "/default");
                if (defaultNE == null) break block2;
                defaultNE.bindToENC(name);
            }
        }
    }

    public void bindResourceEnvRef(String name, Class typeClass) throws Exception {
        block2: {
            try {
                String mappedName = NamingEntryUtil.getMappedName(name);
                NamingEntryUtil.bindToENC(name, mappedName);
            }
            catch (NameNotFoundException e) {
                NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(typeClass.getName() + "/default");
                if (defaultNE == null) break block2;
                defaultNE.bindToENC(name);
            }
        }
    }

    public void bindMessageDestinationRef(String name, Class typeClass) throws Exception {
        block2: {
            try {
                String mappedName = NamingEntryUtil.getMappedName(name);
                NamingEntryUtil.bindToENC(name, mappedName);
            }
            catch (NameNotFoundException e) {
                NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(typeClass.getName() + "/default");
                if (defaultNE == null) break block2;
                defaultNE.bindToENC(name);
            }
        }
    }

    public void bindUserTransaction() throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            Log.info("No Transaction manager found - if your webapp requires one, please configure one.");
        }
    }

    public void configureClassLoader() throws Exception {
        super.configureClassLoader();
    }

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        super.configureWebApp();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.lockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.unlockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
        super.deconfigureWebApp();
    }

    protected void lockCompEnv() throws Exception {
        Random random = new Random();
        this._key = new Integer(random.nextInt());
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.lock", this._key);
    }

    protected void unlockCompEnv() throws Exception {
        if (this._key != null) {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.mortbay.jndi.unlock", this._key);
        }
    }

    public void parseAnnotations() throws Exception {
        Log.info(this.getClass().getName() + " does not support annotations on source. Use org.mortbay.jetty.annotations.Configuration instead");
    }
}

