/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.Link;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class NamingEntryUtil {
    public static String getMappedName(String localName) throws NamingException {
        if (localName == null || "".equals(localName)) {
            return null;
        }
        NamingEntry ne = NamingEntryUtil.lookupNamingEntry(localName);
        if (ne == null) {
            return null;
        }
        if (ne instanceof Link) {
            return (String)((Link)ne).getObjectToBind();
        }
        return null;
    }

    public static void bindToENC(String asName, String mappedName) throws NamingException {
        NamingEntry entry;
        if (asName == null || asName.trim().equals("")) {
            throw new NamingException("No name for NamingEntry");
        }
        if (mappedName == null || "".equals(mappedName)) {
            mappedName = asName;
        }
        if ((entry = NamingEntryUtil.lookupNamingEntry(mappedName)) != null) {
            entry.bindToENC(asName);
        } else {
            try {
                InitialContext ic = new InitialContext();
                Context envContext = (Context)ic.lookup("java:comp/env");
                envContext.lookup(mappedName);
                if (!mappedName.equals(asName)) {
                    NamingUtil.bind(envContext, asName, new LinkRef("." + mappedName));
                }
            }
            catch (NamingException e) {
                throw new NameNotFoundException("No resource to bind matching name=" + mappedName);
            }
        }
    }

    public static NamingEntry lookupNamingEntry(String jndiName) throws NamingException {
        NamingEntry entry = null;
        InitialContext ic = new InitialContext();
        try {
            entry = (NamingEntry)NamingEntryUtil.lookupNamingEntry((Context)ic.lookup("java:comp/env"), jndiName);
        }
        catch (NameNotFoundException e) {
            try {
                entry = (NamingEntry)NamingEntryUtil.lookupNamingEntry(ic, jndiName);
            }
            catch (NameNotFoundException ee) {
                // empty catch block
            }
        }
        return entry;
    }

    public static Object lookupNamingEntry(Context context, String jndiName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name namingEntryName = NamingEntry.makeNamingEntryName(parser, jndiName);
        return context.lookup(namingEntryName.toString());
    }

    public static List lookupNamingEntries(int scopeType, Class clazz) throws NamingException {
        ArrayList list = new ArrayList();
        switch (scopeType) {
            case 0: {
                NamingEntryUtil.lookupNamingEntries(list, new InitialContext(), EnvEntry.class);
                break;
            }
            case 1: {
                InitialContext ic = new InitialContext();
                NamingEntryUtil.lookupNamingEntries(list, (Context)ic.lookup("java:comp/env"), EnvEntry.class);
                break;
            }
        }
        return list;
    }

    private static List lookupNamingEntries(List list, Context context, Class clazz) throws NamingException {
        try {
            NamingEnumeration<Binding> nenum = context.listBindings("");
            while (nenum.hasMoreElements()) {
                Binding binding = nenum.next();
                if (binding.getObject() instanceof Context) {
                    NamingEntryUtil.lookupNamingEntries(list, (Context)binding.getObject(), clazz);
                    continue;
                }
                if (!clazz.isInstance(binding.getObject())) continue;
                list.add(binding.getObject());
            }
        }
        catch (NameNotFoundException e) {
            Log.debug("No entries of type " + clazz.getName() + " in context=" + context);
        }
        return list;
    }
}

