/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class EnvEntry
extends NamingEntry {
    private boolean overrideWebXml;

    public static void bindToENC(String name, Object value) throws NamingException {
        if (name == null || name.trim().equals("")) {
            throw new NamingException("No name for EnvEntry");
        }
        EnvEntry envEntry = (EnvEntry)NamingEntryUtil.lookupNamingEntry(name);
        if (envEntry != null && envEntry.isOverrideWebXml()) {
            envEntry.bindToENC(name);
        } else {
            InitialContext ic = new InitialContext();
            Context envCtx = (Context)ic.lookup("java:comp/env");
            NamingUtil.bind(envCtx, name, value);
        }
    }

    public static List lookupGlobalEnvEntries() throws NamingException {
        ArrayList list = new ArrayList();
        EnvEntry.lookupEnvEntries(list, new InitialContext());
        return list;
    }

    private static List lookupEnvEntries(List list, Context context) throws NamingException {
        try {
            NamingEnumeration<Binding> nenum = context.listBindings("");
            while (nenum.hasMoreElements()) {
                Binding binding = nenum.next();
                if (binding.getObject() instanceof Context) {
                    EnvEntry.lookupEnvEntries(list, (Context)binding.getObject());
                    continue;
                }
                if (!EnvEntry.class.isInstance(binding.getObject())) continue;
                list.add(binding.getObject());
            }
        }
        catch (NameNotFoundException e) {
            Log.debug("No EnvEntries in context=" + context);
        }
        return list;
    }

    public EnvEntry(String jndiName, Object objToBind) throws NamingException {
        this(jndiName, objToBind, false);
    }

    public EnvEntry(String jndiName, Object objToBind, boolean overrideWebXml) throws NamingException {
        super(jndiName, objToBind);
        this.overrideWebXml = overrideWebXml;
    }

    public boolean isOverrideWebXml() {
        return this.overrideWebXml;
    }
}

