/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.plus.jaas.JAASGroup;
import org.mortbay.jetty.plus.jaas.JAASUserPrincipal;
import org.mortbay.jetty.plus.jaas.RoleCheckPolicy;
import org.mortbay.jetty.plus.jaas.callback.AbstractCallbackHandler;
import org.mortbay.jetty.plus.jaas.callback.DefaultCallbackHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.Loader;

public class JAASUserRealm
implements UserRealm {
    public static String DEFAULT_ROLE_CLASS_NAME = "org.mortbay.jetty.plus.jaas.JAASRole";
    public static String[] DEFAULT_ROLE_CLASS_NAMES = new String[]{DEFAULT_ROLE_CLASS_NAME};
    protected String[] roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
    protected String callbackHandlerClass;
    protected String realmName;
    protected String loginModuleName;
    protected RoleCheckPolicy roleCheckPolicy;
    protected JAASUserPrincipal defaultUser = new JAASUserPrincipal(null, null);

    public JAASUserRealm() {
    }

    public JAASUserRealm(String name) {
        this();
        this.realmName = name;
    }

    public String getName() {
        return this.realmName;
    }

    public void setName(String name) {
        this.realmName = name;
    }

    public void setLoginModuleName(String name) {
        this.loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this.callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (classnames != null) {
            tmp.addAll(Arrays.asList(classnames));
        }
        if (!tmp.contains(DEFAULT_ROLE_CLASS_NAME)) {
            tmp.add(DEFAULT_ROLE_CLASS_NAME);
        }
        this.roleClassNames = tmp.toArray(new String[tmp.size()]);
    }

    public String[] getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleCheckPolicy(RoleCheckPolicy policy) {
        this.roleCheckPolicy = policy;
    }

    public Principal getPrincipal(String username) {
        return null;
    }

    public boolean isUserInRole(Principal user, String role) {
        JAASUserPrincipal thePrincipal = null;
        if (user == null) {
            thePrincipal = this.defaultUser;
        } else {
            if (!(user instanceof JAASUserPrincipal)) {
                return false;
            }
            thePrincipal = (JAASUserPrincipal)user;
        }
        return ((JAASUserPrincipal)user).isUserInRole(role);
    }

    public boolean reauthenticate(Principal user) {
        return user instanceof JAASUserPrincipal;
    }

    public Principal authenticate(String username, Object credentials, Request request) {
        try {
            AbstractCallbackHandler callbackHandler = null;
            if (this.callbackHandlerClass == null) {
                Log.warn("No CallbackHandler configured: using DefaultCallbackHandler");
                callbackHandler = new DefaultCallbackHandler();
            } else {
                callbackHandler = (AbstractCallbackHandler)Loader.loadClass(JAASUserRealm.class, this.callbackHandlerClass).getConstructors()[0].newInstance(new Object[0]);
            }
            if (callbackHandler instanceof DefaultCallbackHandler) {
                ((DefaultCallbackHandler)callbackHandler).setRequest(request);
            }
            callbackHandler.setUserName(username);
            callbackHandler.setCredential(credentials);
            LoginContext loginContext = new LoginContext(this.loginModuleName, callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this, username);
            userPrincipal.setSubject(loginContext.getSubject());
            userPrincipal.setRoleCheckPolicy(this.roleCheckPolicy);
            userPrincipal.setLoginContext(loginContext);
            return userPrincipal;
        }
        catch (Exception e) {
            Log.warn(e.toString());
            Log.debug(e);
            return null;
        }
    }

    public void disassociate(Principal user) {
        if (user == null) {
            this.defaultUser.disassociate();
        } else {
            ((JAASUserPrincipal)user).disassociate();
        }
    }

    public Principal pushRole(Principal user, String role) {
        JAASUserPrincipal thePrincipal = (JAASUserPrincipal)user;
        if (thePrincipal == null) {
            thePrincipal = this.defaultUser;
        }
        thePrincipal.pushRole(role);
        return thePrincipal;
    }

    public Principal popRole(Principal user) {
        JAASUserPrincipal thePrincipal = (JAASUserPrincipal)user;
        if (thePrincipal == null) {
            thePrincipal = this.defaultUser;
        }
        thePrincipal.popRole();
        return thePrincipal;
    }

    public Group getRoles(JAASUserPrincipal principal) {
        String[] roleClassNames = this.getRoleClassNames();
        JAASGroup roleGroup = new JAASGroup("__roles__");
        try {
            JAASUserPrincipal thePrincipal = principal;
            if (thePrincipal == null) {
                thePrincipal = this.defaultUser;
            }
            for (int i = 0; i < roleClassNames.length; ++i) {
                Class<?> load_class = Thread.currentThread().getContextClassLoader().loadClass(roleClassNames[i]);
                Set<?> rolesForType = thePrincipal.getSubject().getPrincipals(load_class);
                Iterator<?> itor = rolesForType.iterator();
                while (itor.hasNext()) {
                    roleGroup.addMember((Principal)itor.next());
                }
            }
            return roleGroup;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void logout(Principal user) {
        try {
            JAASUserPrincipal authenticUser = null;
            if (user == null) {
                authenticUser = this.defaultUser;
            }
            if (!(user instanceof JAASUserPrincipal)) {
                throw new IllegalArgumentException(user + " is not a JAASUserPrincipal");
            }
            authenticUser = (JAASUserPrincipal)user;
            authenticUser.getLoginContext().logout();
            Log.debug(user + " has been LOGGED OUT");
        }
        catch (LoginException e) {
            Log.warn(e);
        }
    }
}

