/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.resource.Resource;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.URIUtil;

public class ContextHandler
extends HandlerWrapper
implements Attributes,
Server.Graceful {
    private static ThreadLocal __context = new ThreadLocal();
    protected SContext _scontext;
    private Attributes _attributes;
    private Attributes _contextAttributes;
    private ClassLoader _classLoader;
    private String _contextPath = "/";
    private Map _initParams;
    private String _displayName;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private String[] _vhosts;
    private Set _connectors;
    private EventListener[] _eventListeners;
    private Logger _logger;
    private boolean _shutdown;
    private boolean _allowNullPathInfo;
    private int _maxFormContentSize = Integer.getInteger("org.mortbay.jetty.Request.maxFormContentSize", 200000);
    private boolean _compactPath = false;
    private boolean _aliases = true;
    private Object _contextListeners;
    private Object _contextAttributeListeners;
    private Object _requestListeners;
    private Object _requestAttributeListeners;

    public static SContext getCurrentContext() {
        SContext context = (SContext)__context.get();
        return context;
    }

    public ContextHandler() {
        this._scontext = new SContext();
        this._attributes = new AttributesMap();
        this._initParams = new HashMap();
    }

    protected ContextHandler(SContext context) {
        this._scontext = context;
        this._attributes = new AttributesMap();
        this._initParams = new HashMap();
    }

    public ContextHandler(String contextPath) {
        this();
        this.setContextPath(contextPath);
    }

    public ContextHandler(HandlerContainer parent, String contextPath) {
        this();
        this.setContextPath(contextPath);
        parent.addHandler(this);
    }

    public SContext getServletContext() {
        return this._scontext;
    }

    public boolean getAllowNullPathInfo() {
        return this._allowNullPathInfo;
    }

    public void setAllowNullPathInfo(boolean allowNullPathInfo) {
        this._allowNullPathInfo = allowNullPathInfo;
    }

    public void setServer(Server server) {
        if (this._errorHandler != null) {
            Server old_server = this.getServer();
            if (old_server != null && old_server != server) {
                old_server.getContainer().update((Object)this, this._errorHandler, null, "error", true);
            }
            super.setServer(server);
            if (server != null && server != old_server) {
                server.getContainer().update((Object)this, null, this._errorHandler, "error", true);
            }
            this._errorHandler.setServer(server);
        } else {
            super.setServer(server);
        }
    }

    public void setVirtualHosts(String[] vhosts) {
        if (vhosts == null) {
            this._vhosts = vhosts;
        } else {
            this._vhosts = new String[vhosts.length];
            for (int i = 0; i < vhosts.length; ++i) {
                this._vhosts[i] = this.normalizeHostname(vhosts[i]);
            }
        }
    }

    public String[] getVirtualHosts() {
        return this._vhosts;
    }

    public void setHosts(String[] hosts) {
        this.setConnectorNames(hosts);
    }

    public String[] getHosts() {
        return this.getConnectorNames();
    }

    public String[] getConnectorNames() {
        if (this._connectors == null || this._connectors.size() == 0) {
            return null;
        }
        return this._connectors.toArray(new String[this._connectors.size()]);
    }

    public void setConnectorNames(String[] connectors) {
        this._connectors = connectors == null || connectors.length == 0 ? null : new HashSet<String>(Arrays.asList(connectors));
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getClassPath() {
        if (this._classLoader == null || !(this._classLoader instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader loader = (URLClassLoader)this._classLoader;
        URL[] urls = loader.getURLs();
        StringBuilder classpath = new StringBuilder();
        for (int i = 0; i < urls.length; ++i) {
            try {
                Resource resource = this.newResource(urls[i]);
                File file = resource.getFile();
                if (!file.exists()) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparatorChar);
                }
                classpath.append(file.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                Log.debug(e);
            }
        }
        if (classpath.length() == 0) {
            return null;
        }
        return classpath.toString();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String name) {
        return (String)this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public Map getInitParams() {
        return this._initParams;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public EventListener[] getEventListeners() {
        return this._eventListeners;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this._contextListeners = null;
        this._contextAttributeListeners = null;
        this._requestListeners = null;
        this._requestAttributeListeners = null;
        this._eventListeners = eventListeners;
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = this._eventListeners[i];
            if (listener instanceof ServletContextListener) {
                this._contextListeners = LazyList.add(this._contextListeners, listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
            }
            if (listener instanceof ServletRequestListener) {
                this._requestListeners = LazyList.add(this._requestListeners, listener);
            }
            if (!(listener instanceof ServletRequestAttributeListener)) continue;
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
    }

    public void addEventListener(EventListener listener) {
        this.setEventListeners((EventListener[])LazyList.addToArray(this.getEventListeners(), listener, EventListener.class));
    }

    public boolean isShutdown() {
        return !this._shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this._shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this._contextPath == null) {
            throw new IllegalStateException("Null contextPath");
        }
        this._logger = Log.getLogger(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName());
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Object old_context = null;
        this._contextAttributes = new AttributesMap();
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            if (this._mimeTypes == null) {
                this._mimeTypes = new MimeTypes();
            }
            old_context = __context.get();
            __context.set(this._scontext);
            if (this._errorHandler == null) {
                this.setErrorHandler(new ErrorHandler());
            }
            this.startContext();
        }
        finally {
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
    }

    protected void startContext() throws Exception {
        super.doStart();
        if (this._errorHandler != null) {
            this._errorHandler.start();
        }
        if (this._contextListeners != null) {
            ServletContextEvent event = new ServletContextEvent(this._scontext);
            for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Object old_context = __context.get();
        __context.set(this._scontext);
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            super.doStop();
            if (this._contextListeners != null) {
                ServletContextEvent event = new ServletContextEvent(this._scontext);
                int i = LazyList.size(this._contextListeners);
                while (i-- > 0) {
                    ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextDestroyed(event);
                }
            }
            if (this._errorHandler != null) {
                this._errorHandler.stop();
            }
        }
        finally {
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        if (this._contextAttributes != null) {
            this._contextAttributes.clearAttributes();
        }
        this._contextAttributes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Request base_request;
        String pathInfo;
        Thread current_thread;
        ClassLoader old_classloader;
        String old_path_info;
        String old_servlet_path;
        String old_context_path;
        SContext old_context;
        boolean new_context;
        block35: {
            block37: {
                new_context = false;
                old_context = null;
                old_context_path = null;
                old_servlet_path = null;
                old_path_info = null;
                old_classloader = null;
                current_thread = null;
                pathInfo = null;
                base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                if (!this.isStarted()) return;
                if (this._shutdown) return;
                if (dispatch == 1 && base_request.isHandled()) {
                    return;
                }
                old_context = base_request.getContext();
                if (old_context == this._scontext) break block35;
                new_context = true;
                if (this._vhosts != null && this._vhosts.length > 0) {
                    String vhost = this.normalizeHostname(request.getServerName());
                    boolean match = false;
                    for (int i = 0; !match && i < this._vhosts.length; ++i) {
                        match = this._vhosts[i] != null && this._vhosts[i].equalsIgnoreCase(vhost);
                    }
                    if (!match) {
                        return;
                    }
                }
                if (this._connectors != null && this._connectors.size() > 0) {
                    String connector = HttpConnection.getCurrentConnection().getConnector().getName();
                    if (connector == null) return;
                    if (!this._connectors.contains(connector)) {
                        return;
                    }
                }
                if (dispatch != 1) break block35;
                if (this._compactPath) {
                    target = URIUtil.compactPath(target);
                }
                if (!target.equals(this._contextPath)) break block37;
                if (this._contextPath.length() == 1) {
                    target = "/";
                    pathInfo = "/";
                    break block35;
                } else if (this._allowNullPathInfo) {
                    target = "/";
                    pathInfo = null;
                    request.setAttribute("org.mortbay.jetty.nullPathInfo", target);
                    break block35;
                } else {
                    base_request.setHandled(true);
                    if (request.getQueryString() != null) {
                        response.sendRedirect(URIUtil.addPaths(request.getRequestURI(), "/") + "?" + request.getQueryString());
                        return;
                    }
                    response.sendRedirect(URIUtil.addPaths(request.getRequestURI(), "/"));
                    return;
                }
            }
            if (!target.startsWith(this._contextPath)) return;
            if (this._contextPath.length() != 1) {
                if (target.charAt(this._contextPath.length()) != '/') return;
            }
            if (this._contextPath.length() > 1) {
                target = target.substring(this._contextPath.length());
            }
            pathInfo = target;
        }
        try {
            block36: {
                old_context_path = base_request.getContextPath();
                old_servlet_path = base_request.getServletPath();
                old_path_info = base_request.getPathInfo();
                base_request.setContext(this._scontext);
                if (dispatch != 4 && target.startsWith("/")) {
                    if (this._contextPath.length() == 1) {
                        base_request.setContextPath("");
                    } else {
                        base_request.setContextPath(this._contextPath);
                    }
                    base_request.setServletPath(null);
                    base_request.setPathInfo(pathInfo);
                }
                ServletRequestEvent event = null;
                if (new_context) {
                    int i;
                    if (this._classLoader != null) {
                        current_thread = Thread.currentThread();
                        old_classloader = current_thread.getContextClassLoader();
                        current_thread.setContextClassLoader(this._classLoader);
                    }
                    if (this._requestListeners != null) {
                        event = new ServletRequestEvent(this._scontext, request);
                        for (i = 0; i < LazyList.size(this._requestListeners); ++i) {
                            ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestInitialized(event);
                        }
                    }
                    for (i = 0; i < LazyList.size(this._requestAttributeListeners); ++i) {
                        base_request.addEventListener((EventListener)LazyList.get(this._requestAttributeListeners, i));
                    }
                }
                try {
                    if (dispatch == 1 && this.isProtectedTarget(target)) {
                        throw new HttpException(404);
                    }
                    Handler handler = this.getHandler();
                    if (handler != null) {
                        handler.handle(target, request, response, dispatch);
                    }
                }
                catch (HttpException e) {
                    Log.debug(e);
                    response.sendError(e.getStatus(), e.getReason());
                }
                finally {
                    if (!new_context) break block36;
                    int i = LazyList.size(this._requestListeners);
                    while (i-- > 0) {
                        ((ServletRequestListener)LazyList.get(this._requestListeners, i)).requestDestroyed(event);
                    }
                    for (i = 0; i < LazyList.size(this._requestAttributeListeners); ++i) {
                        base_request.removeEventListener((EventListener)LazyList.get(this._requestAttributeListeners, i));
                    }
                }
            }
            if (old_context == this._scontext) return;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            return;
        }
        catch (Throwable throwable) {
            if (old_context == this._scontext) throw throwable;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            throw throwable;
        }
    }

    protected boolean isProtectedTarget(String target) {
        return false;
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        if (contextPath != null && contextPath.length() > 1 && contextPath.endsWith("/")) {
            throw new IllegalArgumentException("ends with /");
        }
        this._contextPath = contextPath;
        if (this.getServer() != null && (this.getServer().isStarting() || this.getServer().isStarted())) {
            Handler[] contextCollections = this.getServer().getChildHandlersByClass(ContextHandlerCollection.class);
            for (int h = 0; contextCollections != null && h < contextCollections.length; ++h) {
                ((ContextHandlerCollection)contextCollections[h]).mapContexts();
            }
        }
    }

    public void setInitParams(Map initParams) {
        if (initParams == null) {
            return;
        }
        this._initParams = new HashMap(initParams);
    }

    public void setDisplayName(String servletContextName) {
        this._displayName = servletContextName;
        if (this._classLoader != null && this._classLoader instanceof WebAppClassLoader) {
            ((WebAppClassLoader)this._classLoader).setName(servletContextName);
        }
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(this.newResource(resourceBase));
        }
        catch (Exception e) {
            Log.warn(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public boolean isAliases() {
        return this._aliases;
    }

    public void setAliases(boolean aliases) {
        this._aliases = aliases;
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(String[] files) {
        this._welcomeFiles = files;
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            errorHandler.setServer(this.getServer());
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._errorHandler, errorHandler, "errorHandler", true);
        }
        this._errorHandler = errorHandler;
    }

    public int getMaxFormContentSize() {
        return this._maxFormContentSize;
    }

    public void setMaxFormContentSize(int maxSize) {
        this._maxFormContentSize = maxSize;
    }

    public boolean isCompactPath() {
        return this._compactPath;
    }

    public void setCompactPath(boolean compactPath) {
        this._compactPath = compactPath;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + this.getBaseResource() + "}";
    }

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass(this.getClass(), className);
        }
        return this._classLoader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap();
        }
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = (String)this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this._baseResource.addPath(path);
            if (this._aliases && resource.getAlias() != null) {
                if (resource.exists()) {
                    Log.warn("Aliased resource: " + resource + "~=" + resource.getAlias());
                } else if (Log.isDebugEnabled()) {
                    Log.debug("Aliased resource: " + resource + "~=" + resource.getAlias());
                }
                return null;
            }
            return resource;
        }
        catch (Exception e) {
            Log.ignore(e);
            return null;
        }
    }

    public Resource newResource(URL url) throws IOException {
        return Resource.newResource(url);
    }

    public Resource newResource(String url) throws IOException {
        return Resource.newResource(url);
    }

    public Set getResourcePaths(String path) {
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this.getResource(path);
            if (resource != null && resource.exists()) {
                String[] l;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if ((l = resource.list()) != null) {
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < l.length; ++i) {
                        set.add(path + l[i]);
                    }
                    return set;
                }
            }
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        return Collections.EMPTY_SET;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SContext
    implements ServletContext {
        protected SContext() {
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        @Override
        public ServletContext getContext(String uripath) {
            ContextHandler context = null;
            Handler[] handlers = ContextHandler.this.getServer().getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; i < handlers.length; ++i) {
                ContextHandler ch;
                String context_path;
                if (handlers[i] == null || !handlers[i].isStarted() || !uripath.equals(context_path = (ch = (ContextHandler)handlers[i]).getContextPath()) && (!uripath.startsWith(context_path) || uripath.charAt(context_path.length()) != '/') || context != null && context_path.length() <= context.getContextPath().length()) continue;
                context = ch;
            }
            if (context != null) {
                return context._scontext;
            }
            return null;
        }

        @Override
        public int getMajorVersion() {
            return 3;
        }

        @Override
        public String getMimeType(String file) {
            if (ContextHandler.this._mimeTypes == null) {
                return null;
            }
            Buffer mime = ContextHandler.this._mimeTypes.getMimeByExtension(file);
            if (mime != null) {
                return mime.toString();
            }
            return null;
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        @Override
        public String getRealPath(String path) {
            try {
                Resource resource = ContextHandler.this.getResource(path);
                File file = resource.getFile();
                if (file != null) {
                    return file.getCanonicalPath();
                }
            }
            catch (Exception e) {
                Log.ignore(e);
            }
            return null;
        }

        @Override
        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            return null;
        }

        @Override
        public URL getResource(String path) throws MalformedURLException {
            Resource resource = ContextHandler.this.getResource(path);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                if (url == null) {
                    return null;
                }
                return url.openStream();
            }
            catch (Exception e) {
                Log.ignore(e);
                return null;
            }
        }

        @Override
        public Set getResourcePaths(String path) {
            return ContextHandler.this.getResourcePaths(path);
        }

        @Override
        public String getServerInfo() {
            StringBuilder stringBuilder = new StringBuilder().append("jetty/");
            ContextHandler.this.getServer();
            return stringBuilder.append(Server.getVersion()).toString();
        }

        @Override
        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        @Override
        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Override
        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Override
        public void log(Exception exception, String msg) {
            ContextHandler.this._logger.warn(msg, exception);
        }

        @Override
        public void log(String msg) {
            ContextHandler.this._logger.info(msg, null, null);
        }

        @Override
        public void log(String message, Throwable throwable) {
            ContextHandler.this._logger.warn(message, throwable);
        }

        @Override
        public String getInitParameter(String name) {
            return ContextHandler.this.getInitParameter(name);
        }

        @Override
        public Enumeration getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        @Override
        public synchronized Object getAttribute(String name) {
            Object o = ContextHandler.this.getAttribute(name);
            if (o == null && ContextHandler.this._contextAttributes != null) {
                o = ContextHandler.this._contextAttributes.getAttribute(name);
            }
            return o;
        }

        @Override
        public synchronized Enumeration getAttributeNames() {
            Enumeration e;
            HashSet set = new HashSet();
            if (ContextHandler.this._contextAttributes != null) {
                e = ContextHandler.this._contextAttributes.getAttributeNames();
                while (e.hasMoreElements()) {
                    set.add(e.nextElement());
                }
            }
            e = ContextHandler.this.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        @Override
        public synchronized void setAttribute(String name, Object value) {
            Object old_value;
            if (ContextHandler.this._contextAttributes == null) {
                ContextHandler.this.setAttribute(name, value);
                return;
            }
            Object object = old_value = ContextHandler.this._contextAttributes == null ? null : ContextHandler.this._contextAttributes.getAttribute(name);
            if (value == null) {
                ContextHandler.this._contextAttributes.removeAttribute(name);
            } else {
                ContextHandler.this._contextAttributes.setAttribute(name, value);
            }
            if (ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent(ContextHandler.this._scontext, name, old_value == null ? value : old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i);
                    if (old_value == null) {
                        l.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        l.attributeRemoved(event);
                        continue;
                    }
                    l.attributeReplaced(event);
                }
            }
        }

        @Override
        public synchronized void removeAttribute(String name) {
            if (ContextHandler.this._contextAttributes == null) {
                ContextHandler.this.removeAttribute(name);
                return;
            }
            Object old_value = ContextHandler.this._contextAttributes.getAttribute(name);
            ContextHandler.this._contextAttributes.removeAttribute(name);
            if (old_value != null && ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent(ContextHandler.this._scontext, name, old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ((ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i)).attributeRemoved(event);
                }
            }
        }

        @Override
        public String getServletContextName() {
            String name = ContextHandler.this.getDisplayName();
            if (name == null) {
                name = ContextHandler.this.getContextPath();
            }
            return name;
        }

        @Override
        public String getContextPath() {
            if (ContextHandler.this._contextPath != null && ContextHandler.this._contextPath.equals("/")) {
                return "";
            }
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "ServletContext@" + Integer.toHexString(this.hashCode()) + "{" + (this.getContextPath().equals("") ? "/" : this.getContextPath()) + "," + ContextHandler.this.getBaseResource() + "}";
        }

        @Override
        public void addFilter(String filterName, String description, String className, Map<String, String> initParameters) {
        }

        @Override
        public void addFilterMapping(String filterName, String[] urlPatterns, String[] servletNames, EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter) {
        }

        @Override
        public void addServlet(String servletName, String description, String className, Map<String, String> initParameters, int loadOnStartup) {
        }

        @Override
        public void addServletMapping(String servletName, String[] urlPatterns) {
        }
    }
}

