/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import org.mortbay.io.AsyncEndPoint;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public class Suspendable {
    private static final int __IDLE = 0;
    private static final int __HANDLING = 1;
    private static final int __SUSPENDING = 2;
    private static final int __RESUMING = 3;
    private static final int __COMPLETING = 4;
    private static final int __SUSPENDED = 5;
    private static final int __UNSUSPENDING = 6;
    protected HttpConnection _connection;
    protected int _state;
    protected boolean _initial;
    protected boolean _resumed;
    protected boolean _timeout;
    protected long _timeoutMs;
    protected final Timeout.Task _timeoutTask;

    public Suspendable(HttpConnection connection) {
        this._connection = connection;
        this._state = 0;
        this._initial = true;
        this._resumed = false;
        this._timeoutTask = new Timeout.Task(){

            public void expired() {
                Suspendable.this.expire();
            }
        };
    }

    public long getTimeout() {
        return this._timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResumed() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            return this._resumed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            return this._state == 2 || this._state == 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTimeout() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            return this._timeout;
        }
    }

    public void suspend() {
        long timeout = 30000L;
        this.suspend(timeout);
    }

    public String toString() {
        return this.getStatusString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            return (this._state == 0 ? "IDLE" : (this._state == 1 ? "HANDLING" : (this._state == 2 ? "SUSPENDING" : (this._state == 5 ? "SUSPENDED" : (this._state == 3 ? "RESUMING" : (this._state == 6 ? "UNSUSPENDING" : (this._state == 4 ? "COMPLETING" : "???" + this._state))))))) + (this._initial ? ",initial" : "") + (this._resumed ? ",resumed" : "") + (this._timeout ? ",timeout" : "");
        }
    }

    public void handling() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            switch (this._state) {
                case 1: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 0: {
                    this._initial = true;
                    this._state = 1;
                    return;
                }
                case 2: 
                case 3: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 4: {
                    return;
                }
                case 5: {
                    this.cancelTimeout();
                }
                case 6: {
                    this._state = 1;
                    return;
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    public void suspend(long timeoutMs) {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            switch (this._state) {
                case 1: {
                    this._timeout = false;
                    this._resumed = false;
                    this._state = 2;
                    this._timeoutMs = timeoutMs;
                    return;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: 
                case 3: {
                    if (timeoutMs < this._timeoutMs) {
                        this._timeoutMs = timeoutMs;
                    }
                    return;
                }
                case 4: 
                case 5: 
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    public boolean unhandling() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            switch (this._state) {
                case 1: {
                    this._state = 0;
                    return true;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._initial = false;
                    this._state = 5;
                    this.scheduleTimeout();
                    if (this._state == 5) {
                        return true;
                    }
                }
                case 3: {
                    this._initial = false;
                    this._state = 1;
                    return false;
                }
                case 4: {
                    this._initial = false;
                    this._state = 0;
                    return true;
                }
                case 5: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 6: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    public void resume() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            switch (this._state) {
                case 1: {
                    this._resumed = true;
                    return;
                }
                case 0: {
                    return;
                }
                case 2: {
                    this._resumed = true;
                    this._state = 3;
                    return;
                }
                case 3: {
                    this._resumed = true;
                    this._state = 3;
                    return;
                }
                case 4: {
                    return;
                }
                case 5: {
                    this._resumed = true;
                    this._state = 6;
                    this.cancelTimeout();
                    this.scheduleDispatch();
                    return;
                }
                case 6: {
                    this._resumed = true;
                    return;
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    protected void expire() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            switch (this._state) {
                case 1: {
                    return;
                }
                case 0: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 2: {
                    this._timeout = true;
                    this._state = 3;
                    return;
                }
                case 3: {
                    this._timeout = true;
                    this._state = 3;
                    return;
                }
                case 4: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case 5: {
                    this._timeout = true;
                    this._state = 6;
                    this.cancelTimeout();
                    this.scheduleDispatch();
                    return;
                }
                case 6: {
                    this._timeout = true;
                    return;
                }
            }
            throw new IllegalStateException("" + this._state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() throws IOException {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            switch (this._state) {
                case 1: {
                    this._state = 4;
                    break;
                }
                case 0: {
                    return;
                }
                case 2: 
                case 3: {
                    this._state = 4;
                    break;
                }
                case 4: {
                    return;
                }
                case 5: {
                    this._state = 4;
                    this.cancelTimeout();
                    this.scheduleDispatch();
                    return;
                }
                case 6: {
                    this._state = 4;
                    return;
                }
                default: {
                    throw new IllegalStateException("" + this._state);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Suspendable suspendable = this;
        synchronized (suspendable) {
            this._state = this._state == 5 || this._state == 0 ? 0 : 1;
            this._resumed = false;
            this._initial = true;
            this.cancelTimeout();
        }
    }

    protected void scheduleDispatch() {
        EndPoint endp = this._connection.getEndPoint();
        if (!endp.isBlocking()) {
            ((AsyncEndPoint)endp).dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            Suspendable suspendable = this;
            synchronized (suspendable) {
                long expire_at = System.currentTimeMillis() + this._timeoutMs;
                long wait = this._timeoutMs;
                while (this._timeoutMs > 0L && wait > 0L) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException e) {
                        Log.ignore(e);
                    }
                    wait = expire_at - System.currentTimeMillis();
                }
                if (this._timeoutMs > 0L && wait <= 0L) {
                    this.expire();
                }
            }
        }
        this._connection.scheduleTimeout(this._timeoutTask, this._timeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimeout() {
        EndPoint endp = this._connection.getEndPoint();
        if (endp.isBlocking()) {
            Suspendable suspendable = this;
            synchronized (suspendable) {
                this._timeoutMs = 0L;
                this.notifyAll();
            }
        } else {
            this._connection.cancelTimeout(this._timeoutTask);
        }
    }

    public boolean isCompleting() {
        return this._state == 4;
    }

    public boolean shouldHandleRequest() {
        switch (this._state) {
            case 4: {
                return false;
            }
        }
        return true;
    }

    public boolean shouldComplete() {
        switch (this._state) {
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
        }
        return true;
    }
}

