/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.util.log.Log;

public class FilterHolder
extends Holder {
    private transient Filter _filter;
    private transient Config _config;

    public FilterHolder() {
    }

    public FilterHolder(Class filter) {
        super(filter);
    }

    public FilterHolder(Filter filter) {
        this.setFilter(filter);
    }

    public void doStart() throws Exception {
        super.doStart();
        if (!Filter.class.isAssignableFrom(this._class)) {
            String msg = this._class + " is not a javax.servlet.Filter";
            super.stop();
            throw new IllegalStateException(msg);
        }
        if (this._filter == null) {
            this._filter = (Filter)this.newInstance();
        }
        this._filter = this.getServletHandler().customizeFilter(this._filter);
        this._config = new Config();
        this._filter.init(this._config);
    }

    public void doStop() throws Exception {
        if (this._filter != null) {
            try {
                this.destroyInstance(this._filter);
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
        if (!this._extInstance) {
            this._filter = null;
        }
        this._config = null;
        super.doStop();
    }

    public void destroyInstance(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Filter f = (Filter)o;
        f.destroy();
        this.getServletHandler().customizeFilterDestroy(f);
    }

    public synchronized void setFilter(Filter filter) {
        this._filter = filter;
        this._extInstance = true;
        this.setHeldClass(filter.getClass());
        if (this.getName() == null) {
            this.setName(filter.getClass().getName());
        }
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String toString() {
        return this.getName();
    }

    class Config
    extends Holder.HolderConfig
    implements FilterConfig {
        Config() {
        }

        public String getFilterName() {
            return FilterHolder.this._name;
        }
    }
}

