/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.eclipse.jetty.server.newSessionId";
    protected static final String SESSION_ID_RANDOM_ALGORITHM = "SHA1PRNG";
    protected static final String SESSION_ID_RANDOM_ALGORITHM_ALT = "IBMSecureRandom";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;
    protected final Server _server;

    public AbstractSessionIdManager(Server server) {
        this._server = server;
    }

    public AbstractSessionIdManager(Server server, Random random) {
        this._random = random;
        this._server = server;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String name) {
        this._workerName = name;
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newSessionId(HttpServletRequest request, long created) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            String cluster_id;
            String requested_id = request.getRequestedSessionId();
            if (requested_id != null && this.idInUse(cluster_id = this.getClusterId(requested_id))) {
                return cluster_id;
            }
            String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
            if (new_id != null && this.idInUse(new_id)) {
                return new_id;
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                r ^= created;
                if (request != null && request.getRemoteAddr() != null) {
                    r ^= (long)request.getRemoteAddr().hashCode();
                }
                if (r < 0L) {
                    r = -r;
                }
                id = Long.toString(r, 36);
                id = this._workerName + id;
            }
            request.setAttribute(__NEW_SESSION_ID, id);
            return id;
        }
    }

    public void doStart() {
        this.initRandom();
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this._random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM_ALT);
                    this._weakRandom = false;
                }
                catch (NoSuchAlgorithmException e_alt) {
                    Log.warn("Could not generate SecureRandom for session-id randomness", e);
                    this._random = new Random();
                    this._weakRandom = true;
                }
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
    }
}

