/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DelegateAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class SessionCachingAuthenticator
extends DelegateAuthenticator {
    public static final String __J_AUTHENTICATED = "org.eclipse.jetty.server.Auth";

    public SessionCachingAuthenticator(Authenticator delegate) {
        super(delegate);
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        HttpSession session = ((HttpServletRequest)request).getSession(mandatory);
        if (session == null) {
            return Authentication.NOT_CHECKED;
        }
        Authentication authentication = (Authentication)session.getAttribute(__J_AUTHENTICATED);
        if (authentication != null) {
            return authentication;
        }
        authentication = this._delegate.validateRequest(request, response, mandatory);
        if (authentication instanceof Authentication.User) {
            SessionAuthentication cached = new SessionAuthentication(this._delegate, ((Authentication.User)authentication).getUserIdentity());
            session.setAttribute(__J_AUTHENTICATED, cached);
        }
        return authentication;
    }

    protected class SessionAuthentication
    extends UserAuthentication
    implements HttpSessionAttributeListener {
        public SessionAuthentication(Authenticator authenticator, UserIdentity userIdentity) {
            super(authenticator, userIdentity);
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            this.logout();
        }

        public void attributeReplaced(HttpSessionBindingEvent arg0) {
            this.logout();
        }

        public String toString() {
            return "Session" + super.toString();
        }
    }
}

