/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler.rewrite;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.handler.rewrite.LegacyRule;
import org.mortbay.jetty.handler.rewrite.Rule;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class RewriteHandler
extends HandlerWrapper {
    private Rule[] _rules;
    private String _originalPathAttribute;
    private boolean _rewriteRequestURI = true;
    private boolean _rewritePathInfo = true;
    private LegacyRule _legacy;

    private LegacyRule getLegacyRule() {
        if (this._legacy == null) {
            this._legacy = new LegacyRule();
            this.addRule(this._legacy);
        }
        return this._legacy;
    }

    public void setLegacyRule(LegacyRule legacyRule) {
        this._legacy = legacyRule;
    }

    public Rule[] getRules() {
        return this._rules;
    }

    public void setRules(Rule[] rules) {
        if (this._legacy == null) {
            this._rules = rules;
        } else {
            this._rules = null;
            this.addRule(this._legacy);
            if (rules != null) {
                for (Rule rule : rules) {
                    this.addRule(rule);
                }
            }
        }
    }

    public void addRule(Rule rule) {
        this._rules = (Rule[])LazyList.addToArray((Object[])this._rules, (Object)rule, Rule.class);
    }

    public boolean isRewriteRequestURI() {
        return this._rewriteRequestURI;
    }

    public void setRewriteRequestURI(boolean rewriteRequestURI) {
        this._rewriteRequestURI = rewriteRequestURI;
    }

    public boolean isRewritePathInfo() {
        return this._rewritePathInfo;
    }

    public void setRewritePathInfo(boolean rewritePathInfo) {
        this._rewritePathInfo = rewritePathInfo;
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribte) {
        this._originalPathAttribute = originalPathAttribte;
    }

    public PathMap getRewrite() {
        return this.getLegacyRule().getRewrite();
    }

    public void setRewrite(PathMap rewrite) {
        this.getLegacyRule().setRewrite(rewrite);
    }

    public void addRewriteRule(String pattern, String prefix) {
        this.getLegacyRule().addRewriteRule(pattern, prefix);
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this.isStarted()) {
            boolean handled = false;
            boolean original_set = this._originalPathAttribute == null;
            for (Rule rule : this._rules) {
                String applied = rule.matchAndApply(target, request, response);
                if (applied == null) continue;
                Log.debug((String)"applied {}", (Object)rule);
                if (!target.equals(applied)) {
                    Log.debug((String)"rewrote {} to {}", (Object)target, (Object)applied);
                    if (!original_set) {
                        original_set = true;
                        request.setAttribute(this._originalPathAttribute, (Object)target);
                    }
                    if (this._rewriteRequestURI) {
                        ((Request)request).setRequestURI(applied);
                    }
                    if (this._rewritePathInfo) {
                        ((Request)request).setPathInfo(applied);
                    }
                    target = applied;
                }
                if (rule.isHandling()) {
                    Log.debug((String)"handling {}", (Object)rule);
                    handled = true;
                    (request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest()).setHandled(true);
                }
                if (!rule.isTerminating()) continue;
                Log.debug((String)"terminating {}", (Object)rule);
                break;
            }
            if (!handled) {
                super.handle(target, request, response, dispatch);
            }
        }
    }
}

