/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas.spi;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.mortbay.jetty.plus.jaas.callback.ObjectCallback;
import org.mortbay.jetty.plus.jaas.spi.AbstractLoginModule;
import org.mortbay.jetty.plus.jaas.spi.UserInfo;
import org.mortbay.jetty.security.Credential;
import org.mortbay.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapLoginModule
extends AbstractLoginModule {
    private String _hostname;
    private int _port;
    private String _authenticationMethod;
    private String _contextFactory;
    private String _bindDn;
    private String _bindPassword;
    private String _userObjectClass = "inetOrgPerson";
    private String _userRdnAttribute = "uid";
    private String _userIdAttribute = "cn";
    private String _userPasswordAttribute = "userPassword";
    private String _userBaseDn;
    private String _roleBaseDn;
    private String _roleObjectClass = "groupofuniquenames";
    private String _roleMemberAttribute = "uniqueMember";
    private String _roleNameAttribute = "roleName";
    private boolean _forceBindingLogin = false;
    private DirContext _rootContext;

    @Override
    public UserInfo getUserInfo(String username) throws Exception {
        String pwdCredential = this.getUserCredentials(username);
        pwdCredential = LdapLoginModule.convertCredentialLdapToJetty(pwdCredential);
        Credential credential = Credential.getCredential((String)pwdCredential);
        List roles = this.getUserRoles(username);
        return new UserInfo(username, credential, roles);
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private String getUserCredentials(String username) throws LoginException {
        String ldapCredential;
        block6: {
            ldapCredential = null;
            SearchControls ctls = new SearchControls();
            ctls.setCountLimit(1L);
            ctls.setDerefLinkFlag(true);
            ctls.setSearchScope(2);
            String filter = "(&(objectClass=" + this._userObjectClass + ")(" + this._userIdAttribute + "=" + username + "))";
            Log.debug((String)("Searching for users with filter: '" + filter + "'" + " from base dn: " + this._userBaseDn));
            try {
                NamingEnumeration<SearchResult> results = this._rootContext.search(this._userBaseDn, filter, ctls);
                Log.debug((String)("Found user?: " + results.hasMoreElements()));
                if (results.hasMoreElements()) {
                    SearchResult result = (SearchResult)results.nextElement();
                    Attributes attributes = result.getAttributes();
                    Attribute attribute = attributes.get(this._userPasswordAttribute);
                    if (attribute != null) {
                        try {
                            byte[] value = (byte[])attribute.get();
                            ldapCredential = new String(value);
                        }
                        catch (NamingException e) {
                            Log.debug((String)("no password available under attribute: " + this._userPasswordAttribute));
                        }
                    }
                    break block6;
                }
                throw new LoginException("User not found.");
            }
            catch (NamingException e) {
                throw new LoginException("Root context binding failure.");
            }
        }
        Log.debug((String)("user cred is: " + ldapCredential));
        return ldapCredential;
    }

    private List getUserRoles(String username) throws LoginException {
        ArrayList<String> roleList = new ArrayList<String>();
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        if (this._roleBaseDn != null) {
            String userDn = this._userRdnAttribute + "=" + username + "," + this._userBaseDn;
            String filter = "(&(objectClass=" + this._roleObjectClass + ")(" + this._roleMemberAttribute + "=" + userDn + "))";
            try {
                NamingEnumeration<SearchResult> results = this._rootContext.search(this._roleBaseDn, filter, ctls);
                Log.debug((String)("Found user roles?: " + results.hasMoreElements()));
                while (results.hasMoreElements()) {
                    Attribute roleAttribute;
                    SearchResult result = (SearchResult)results.nextElement();
                    Attributes attributes = result.getAttributes();
                    if (attributes == null || (roleAttribute = attributes.get(this._roleNameAttribute)) == null) continue;
                    NamingEnumeration<?> roles = roleAttribute.getAll();
                    while (roles.hasMore()) {
                        String roleName = (String)roles.next();
                        roleList.add(roleName);
                    }
                }
            }
            catch (NamingException e) {
                throw new LoginException("error obtaining roles for " + username);
            }
        }
        return roleList;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            if (this.getCallbackHandler() == null) {
                throw new LoginException("No callback handler");
            }
            Callback[] callbacks = this.configureCallbacks();
            this.getCallbackHandler().handle(callbacks);
            String webUserName = ((NameCallback)callbacks[0]).getName();
            Object webCredential = ((ObjectCallback)callbacks[1]).getObject();
            if (webUserName == null || webCredential == null) {
                this.setAuthenticated(false);
                return this.isAuthenticated();
            }
            UserInfo userInfo = this.getUserInfo(webUserName);
            this.setCurrentUser(new AbstractLoginModule.JAASUserInfo(userInfo));
            if (userInfo.getCredential() == null || this._forceBindingLogin) {
                return this.bindingLogin(webUserName, webCredential);
            }
            if (webCredential instanceof String) {
                return this.credentialLogin(Credential.getCredential((String)((String)webCredential)));
            }
            return this.credentialLogin(webCredential);
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("Error obtaining callback information.");
        }
        catch (IOException e) {
            throw new LoginException("IO Error performing login.");
        }
        catch (Exception e) {
            throw new LoginException("Error obtaining user info.");
        }
    }

    protected boolean credentialLogin(Object webCredential) throws LoginException {
        this.setAuthenticated(this.getCurrentUser().checkCredential(webCredential));
        return this.isAuthenticated();
    }

    protected boolean bindingLogin(String username, Object password) throws LoginException {
        SearchControls ctls = new SearchControls();
        ctls.setCountLimit(1L);
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        String filter = "(&(objectClass=" + this._userObjectClass + ")(" + this._userIdAttribute + "=" + username + "))";
        Log.info((String)("Searching for users with filter: '" + filter + "'" + " from base dn: " + this._userBaseDn));
        try {
            NamingEnumeration<SearchResult> results = this._rootContext.search(this._userBaseDn, filter, ctls);
            Log.info((String)("Found user?: " + results.hasMoreElements()));
            if (results.hasMoreElements()) {
                SearchResult result = (SearchResult)results.nextElement();
                String userDn = result.getNameInNamespace();
                Log.info((String)("Attempting Authenication: + " + userDn));
                Hashtable<Object, Object> environment = this.getEnvironment();
                environment.put("java.naming.security.principal", userDn);
                environment.put("java.naming.security.credentials", password);
                try {
                    InitialDirContext userContext = new InitialDirContext(environment);
                }
                catch (AuthenticationException e) {
                    Log.info((String)("Authentication failed for: " + userDn));
                    throw new LoginException();
                }
                catch (NamingException ne) {
                    throw new LoginException("Context binding failure.");
                }
                this.setAuthenticated(true);
                return true;
            }
            throw new LoginException("User not found.");
        }
        catch (NamingException e) {
            throw new LoginException("Context binding failure.");
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this._hostname = (String)options.get("hostname");
        this._port = Integer.parseInt((String)options.get("port"));
        this._contextFactory = (String)options.get("contextFactory");
        this._bindDn = (String)options.get("bindDn");
        this._bindPassword = (String)options.get("bindPassword");
        this._authenticationMethod = (String)options.get("authenticationMethod");
        this._userBaseDn = (String)options.get("userBaseDn");
        this._roleBaseDn = (String)options.get("roleBaseDn");
        if (options.containsKey("forceBindingLogin")) {
            this._forceBindingLogin = Boolean.parseBoolean((String)options.get("forceBindingLogin"));
        }
        if (options.containsKey("userObjectClass")) {
            this._userObjectClass = (String)options.get("userObjectClass");
        }
        if (options.containsKey("userRdnAttribute")) {
            this._userRdnAttribute = (String)options.get("userRdnAttribute");
        }
        if (options.containsKey("userIdAttribute")) {
            this._userIdAttribute = (String)options.get("userIdAttribute");
        }
        if (options.containsKey("userPasswordAttribute")) {
            this._userPasswordAttribute = (String)options.get("userPasswordAttribute");
        }
        if (options.containsKey("roleObjectClass")) {
            this._roleObjectClass = (String)options.get("roleObjectClass");
        }
        if (options.containsKey("roleMemberAttribute")) {
            this._roleMemberAttribute = (String)options.get("roleMemberAttribute");
        }
        if (options.containsKey("roleNameAttribute")) {
            this._roleNameAttribute = (String)options.get("roleNameAttribute");
        }
        try {
            this._rootContext = new InitialDirContext(this.getEnvironment());
        }
        catch (NamingException ex) {
            throw new IllegalStateException("Unable to establish root context", ex);
        }
    }

    public Hashtable<Object, Object> getEnvironment() {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", this._contextFactory);
        if (this._hostname != null) {
            if (this._port != 0) {
                env.put("java.naming.provider.url", "ldap://" + this._hostname + ":" + this._port + "/");
            } else {
                env.put("java.naming.provider.url", "ldap://" + this._hostname + "/");
            }
        }
        if (this._authenticationMethod != null) {
            env.put("java.naming.security.authentication", this._authenticationMethod);
        }
        if (this._bindDn != null) {
            env.put("java.naming.security.principal", this._bindDn);
        }
        if (this._bindPassword != null) {
            env.put("java.naming.security.credentials", this._bindPassword);
        }
        return env;
    }

    public static String convertCredentialJettyToLdap(String encryptedPassword) {
        if (encryptedPassword.toUpperCase().startsWith("MD5:")) {
            String epwd = encryptedPassword.substring("MD5:".length(), encryptedPassword.length());
            return "{MD5}" + epwd;
        }
        if (encryptedPassword.toUpperCase().startsWith("CRYPT:")) {
            String epwd = encryptedPassword.substring("CRYPT:".length(), encryptedPassword.length());
            return "{CRYPT}" + epwd;
        }
        return encryptedPassword;
    }

    public static String convertCredentialLdapToJetty(String encryptedPassword) {
        if (encryptedPassword.toUpperCase().startsWith("{MD5}")) {
            String epwd = encryptedPassword.substring("{MD5}".length(), encryptedPassword.length());
            return "MD5:" + epwd;
        }
        if (encryptedPassword.toUpperCase().startsWith("{CRYPT}")) {
            String epwd = encryptedPassword.substring("{CRYPT}".length(), encryptedPassword.length());
            return "CRYPT:" + epwd;
        }
        return encryptedPassword;
    }

    public static byte[] digestMD5(String pwd) throws LoginException {
        byte[] barray;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
            barray = pwd.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new LoginException();
        }
        catch (NoSuchAlgorithmException e1) {
            throw new LoginException();
        }
        for (int i = 0; i < barray.length; ++i) {
            md.update(barray[i]);
        }
        String mdString = md.toString();
        return md.digest();
    }
}

