/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.Resource;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.jetty.plus.webapp.AbstractConfiguration;
import org.mortbay.log.Log;

public class Configuration
extends AbstractConfiguration {
    private Integer _key;

    public void bindEnvEntry(String name, Object value) throws Exception {
        EnvEntry.bindToENC(name, name, value);
    }

    public void bindResourceRef(String name, Class typeClass) throws Exception {
        NamingEntry.bindToENC(name, name, Resource.class);
    }

    public void bindResourceEnvRef(String name, Class typeClass) throws Exception {
        NamingEntry.bindToENC(name, name, Resource.class);
    }

    public void bindMessageDestinationRef(String name, Class typeClass) throws Exception {
        NamingEntry.bindToENC(name, name, Resource.class);
    }

    public void bindUserTransaction() throws Exception {
        try {
            NamingEntry.bindToENC("UserTransaction", "UserTransaction", Transaction.class);
        }
        catch (NameNotFoundException e) {
            Log.info((String)"No Transaction manager found - if your webapp requires one, please configure one.");
        }
    }

    public void configureClassLoader() throws Exception {
        super.configureClassLoader();
    }

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        super.configureWebApp();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.lockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.unlockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
        super.deconfigureWebApp();
    }

    protected void lockCompEnv() throws Exception {
        Random random = new Random();
        this._key = new Integer(random.nextInt());
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.lock", this._key);
    }

    protected void unlockCompEnv() throws Exception {
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.unlock", this._key);
    }

    protected void parseAnnotations() throws Exception {
        Log.info((String)(((Object)((Object)this)).getClass().getCanonicalName() + " does not support annotations on source. Use org.mortbay.jetty.annotations.Configuration instead"));
    }
}

