/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.util.EventListener;
import java.util.Iterator;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.plus.annotation.Injection;
import org.mortbay.jetty.plus.annotation.InjectionCollection;
import org.mortbay.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.mortbay.jetty.plus.annotation.PostConstructCallback;
import org.mortbay.jetty.plus.annotation.PreDestroyCallback;
import org.mortbay.jetty.plus.servlet.ServletHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.webapp.WebXmlConfiguration;
import org.mortbay.log.Log;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;

public abstract class AbstractConfiguration
extends WebXmlConfiguration {
    protected LifeCycleCallbackCollection _callbacks = new LifeCycleCallbackCollection();
    protected InjectionCollection _injections = new InjectionCollection();
    private boolean _metadataComplete = true;

    public abstract void bindEnvEntry(String var1, Object var2) throws Exception;

    public abstract void bindResourceRef(String var1, Class var2) throws Exception;

    public abstract void bindResourceEnvRef(String var1, Class var2) throws Exception;

    public abstract void bindUserTransaction() throws Exception;

    public abstract void bindMessageDestinationRef(String var1, Class var2) throws Exception;

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        super.configureWebApp();
        this.bindUserTransaction();
    }

    public void deconfigureWebApp() throws Exception {
        this.callPreDestroyCallbacks();
        super.deconfigureWebApp();
    }

    public void configure(String webXml) throws Exception {
        super.configure(webXml);
        if (!this._metadataComplete) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Processing annotations");
            }
            this.parseAnnotations();
        }
        this.injectAndCallPostConstructCallbacks();
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        ServletHandler servletHandler = new ServletHandler();
        SecurityHandler securityHandler = this.getWebAppContext().getSecurityHandler();
        org.mortbay.jetty.servlet.ServletHandler existingHandler = this.getWebAppContext().getServletHandler();
        servletHandler.setFilterMappings(existingHandler.getFilterMappings());
        servletHandler.setFilters(existingHandler.getFilters());
        servletHandler.setServlets(existingHandler.getServlets());
        servletHandler.setServletMappings(existingHandler.getServletMappings());
        this.getWebAppContext().setServletHandler((org.mortbay.jetty.servlet.ServletHandler)servletHandler);
        securityHandler.setHandler((Handler)servletHandler);
        super.initialize(config);
        ((ServletHandler)this.getWebAppContext().getServletHandler()).setInjections(this._injections);
        ((ServletHandler)this.getWebAppContext().getServletHandler()).setCallbacks(this._callbacks);
        if (this._version == 25) {
            this._metadataComplete = Boolean.valueOf(config.getAttribute("metadata-complete", "false"));
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("env-entry".equals(element)) {
            this.initEnvEntry(node);
        } else if ("resource-ref".equals(element)) {
            this.initResourceRef(node);
        } else if ("resource-env-ref".equals(element)) {
            this.initResourceEnvRef(node);
        } else if ("message-destination-ref".equals(element)) {
            this.initMessageDestinationRef(node);
        } else if ("post-construct".equals(element)) {
            this.initPostConstruct(node);
        } else if ("pre-destroy".equals(element)) {
            this.initPreDestroy(node);
        } else {
            super.initWebXmlElement(element, node);
        }
    }

    protected void initEnvEntry(XmlParser.Node node) throws Exception {
        String name = node.getString("env-entry-name", false, true);
        String type = node.getString("env-entry-type", false, true);
        String valueStr = node.getString("env-entry-value", false, true);
        if (valueStr == null || valueStr.equals("")) {
            Log.warn((String)("No value for env-entry-name " + name));
            return;
        }
        this.initInjection(node, name, TypeUtil.fromName((String)type));
        Object value = TypeUtil.valueOf((String)type, (String)valueStr);
        this.bindEnvEntry(name, value);
    }

    protected void initResourceRef(XmlParser.Node node) throws Exception {
        String jndiName = node.getString("res-ref-name", false, true);
        String type = node.getString("res-type", false, true);
        String auth = node.getString("res-auth", false, true);
        String shared = node.getString("res-sharing-scope", false, true);
        Class typeClass = TypeUtil.fromName((String)type);
        if (typeClass == null) {
            typeClass = this.getWebAppContext().loadClass(type);
        }
        this.initInjection(node, jndiName, typeClass);
        this.bindResourceRef(jndiName, typeClass);
    }

    protected void initResourceEnvRef(XmlParser.Node node) throws Exception {
        String jndiName = node.getString("resource-env-ref-name", false, true);
        String type = node.getString("resource-env-ref-type", false, true);
        Class typeClass = TypeUtil.fromName((String)type);
        if (typeClass == null) {
            typeClass = this.getWebAppContext().loadClass(type);
        }
        this.initInjection(node, jndiName, typeClass);
        this.bindResourceEnvRef(jndiName, typeClass);
    }

    protected void initMessageDestinationRef(XmlParser.Node node) throws Exception {
        String jndiName = node.getString("message-destination-ref-name", false, true);
        String type = node.getString("message-destination-type", false, true);
        String usage = node.getString("message-destination-usage", false, true);
        Class typeClass = TypeUtil.fromName((String)type);
        if (typeClass == null) {
            typeClass = this.getWebAppContext().loadClass(type);
        }
        this.initInjection(node, jndiName, typeClass);
        this.bindMessageDestinationRef(jndiName, typeClass);
    }

    protected void initPostConstruct(XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.equals("")) {
            Log.warn((String)"No lifecycle-callback-class specified");
            return;
        }
        if (methodName == null || methodName.equals("")) {
            Log.warn((String)("No lifecycle-callback-method specified for class " + className));
            return;
        }
        try {
            Class clazz = this.getWebAppContext().loadClass(className);
            PostConstructCallback callback = new PostConstructCallback();
            callback.setTarget(clazz, methodName);
            this._callbacks.add(callback);
        }
        catch (ClassNotFoundException e) {
            Log.warn((String)("Couldn't load post-construct target class " + className));
        }
    }

    protected void initPreDestroy(XmlParser.Node node) {
        String className = node.getString("lifecycle-callback-class", false, true);
        String methodName = node.getString("lifecycle-callback-method", false, true);
        if (className == null || className.equals("")) {
            Log.warn((String)"No lifecycle-callback-class specified for pre-destroy");
            return;
        }
        if (methodName == null || methodName.equals("")) {
            Log.warn((String)("No lifecycle-callback-method specified for pre-destroy class " + className));
            return;
        }
        try {
            Class clazz = this.getWebAppContext().loadClass(className);
            PreDestroyCallback callback = new PreDestroyCallback();
            callback.setTarget(clazz, methodName);
            this._callbacks.add(callback);
        }
        catch (ClassNotFoundException e) {
            Log.warn((String)("Couldn't load pre-destory target class " + className));
        }
    }

    protected void initInjection(XmlParser.Node node, String jndiName, Class valueClass) {
        Iterator itor = node.iterator("injection-target");
        while (itor.hasNext()) {
            XmlParser.Node injectionNode = (XmlParser.Node)itor.next();
            String targetClassName = injectionNode.getString("injection-target-class", false, true);
            String targetName = injectionNode.getString("injection-target-name", false, true);
            if (targetClassName == null || targetClassName.equals("")) {
                Log.warn((String)"No classname found in injection-target");
                continue;
            }
            if (targetName == null || targetName.equals("")) {
                Log.warn((String)"No field or method name in injection-target");
                continue;
            }
            try {
                Class clazz = this.getWebAppContext().loadClass(targetClassName);
                Injection injection = new Injection();
                injection.setTargetClass(clazz);
                injection.setJndiName(jndiName);
                injection.setTarget(clazz, targetName, valueClass);
                this._injections.add(injection);
            }
            catch (ClassNotFoundException e) {
                Log.warn((String)("Couldn't load injection target class " + targetClassName));
            }
        }
    }

    protected abstract void parseAnnotations() throws Exception;

    protected void injectAndCallPostConstructCallbacks() throws Exception {
        EventListener[] listeners = this.getWebAppContext().getEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this._injections.inject(listeners[i]);
            this._callbacks.callPostConstructCallback(listeners[i]);
        }
    }

    protected void callPreDestroyCallbacks() throws Exception {
        EventListener[] listeners = this.getWebAppContext().getEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this._callbacks.callPreDestroyCallback(listeners[i]);
        }
    }
}

