/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.mortbay.jetty.plugin.JettyWebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenWebInfConfiguration
extends WebInfConfiguration {
    protected Resource _originalResourceBase;

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Setting up classpath ...");
            }
            Iterator<File> itor = jwac.getClassPathFiles().iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(itor.next().getCanonicalPath());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Classpath = " + LazyList.array2List((Object[])((URLClassLoader)context.getClassLoader()).getURLs())));
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "-org.apache.maven.";
        newServerClasses[1] = "-org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        context.setServerClasses(newServerClasses);
    }

    public void preConfigure(WebAppContext context) throws Exception {
        this._originalResourceBase = context.getBaseResource();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getOverlays() != null && !jwac.getOverlays().isEmpty()) {
            ResourceCollection rc = new ResourceCollection();
            if (jwac.getBaseResource() == null) {
                int size = jwac.getOverlays().size() + 1;
                Resource[] resources = new Resource[size];
                for (int i = 0; i < size; ++i) {
                    resources[i] = jwac.getOverlays().get(i);
                    Log.info((String)("Adding overlay: " + resources[i]));
                }
                rc.setResources(resources);
            } else if (jwac.getBaseResource() instanceof ResourceCollection) {
                Resource[] old = ((ResourceCollection)jwac.getBaseResource()).getResources();
                int size = old.length + jwac.getOverlays().size();
                Resource[] resources = new Resource[size];
                System.arraycopy(old, 0, resources, 0, old.length);
                int i = old.length;
                int j = 0;
                while (i < size) {
                    resources[i] = jwac.getOverlays().get(j);
                    Log.info((String)("Adding overlay: " + resources[i]));
                    ++i;
                    ++j;
                }
                rc.setResources(resources);
            } else {
                int size = jwac.getOverlays().size() + 1;
                Resource[] resources = new Resource[size];
                resources[0] = jwac.getBaseResource();
                for (int i = 1; i < size; ++i) {
                    resources[i] = jwac.getOverlays().get(i - 1);
                    Log.info((String)("Adding overlay: " + resources[i]));
                }
                rc.setResources(resources);
            }
            jwac.setBaseResource((Resource)rc);
        }
        super.preConfigure(context);
    }

    public void postConfigure(WebAppContext context) throws Exception {
        super.postConfigure(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        super.deconfigure(context);
        context.setBaseResource(this._originalResourceBase);
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List superList;
        ArrayList<Resource> list = new ArrayList<Resource>();
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            for (File f : jwac.getClassPathFiles()) {
                if (!f.getName().toLowerCase().endsWith(".jar")) continue;
                try {
                    list.add(Resource.newResource((URI)f.toURI()));
                }
                catch (Exception e) {
                    Log.warn((String)"Bad url ", (Throwable)e);
                }
            }
        }
        if ((superList = super.findJars(context)) != null) {
            list.addAll(superList);
        }
        return list;
    }
}

