/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.mortbay.jetty:jetty-maven-plugin:7.0.0.RC2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Jetty :: Jetty Maven Plugin 7.0.0.RC2", 0);
        this.append(sb, "(no description available)", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy-war".equals(this.goal)) {
            this.append(sb, "jetty:deploy-war", 0);
            this.append(sb, "This goal is used to run Jetty with a pre-assembled war.\n\nIt accepts exactly the same options as the run-war goal. However, it doesn't assume that the current artifact is a webapp and doesn't try to assemble it into a war before its execution. So using it makes sense only when used in conjunction with the webApp configuration parameter pointing to a pre-built WAR.\n\nThis goal is useful e.g. for launching a web app in Jetty as a target for unit-tested HTTP client components.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "connectors", 2);
                this.append(sb, "List of connectors to use. If none are configured then the default is a single SelectChannelConnector at port 8080. You can override this default port number by using the system property jetty.port on the command line, eg: mvn -Djetty.port=9999 jetty:run", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextHandlers", 2);
                this.append(sb, "List of other contexts to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "daemon (Default: false)", 2);
                this.append(sb, "Determines whether or not the server blocks when started. The default behavior (daemon = false) will cause the server to pause other processes while it continues to handle web requests. This is useful when starting the server with the intent to work with it interactively.\n\nOften, it is desirable to let the server start and continue running subsequent processes in an automated build environment. This can be facilitated by setting daemon to true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "jettyConfig", 2);
                this.append(sb, "Location of a jetty xml configuration file whose contents will be applied before any plugin configuration. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "loginServices", 2);
                this.append(sb, "List of security realms to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reload (Default: automatic)", 2);
                this.append(sb, "reload can be set to either 'automatic' or 'manual' if 'manual' then the context can be reloaded by a linefeed in the console if 'automatic' then traditional reloading on changed files is enabled.", 3);
                this.append(sb, "", 0);
                this.append(sb, "requestLog", 2);
                this.append(sb, "A RequestLog implementation to use for the webapp at runtime. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scanIntervalSeconds (Default: 0)", 2);
                this.append(sb, "The interval in seconds to scan the webapp for changes and restart the context if necessary. Ignored if reload is enabled. Disabled by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey", 2);
                this.append(sb, "Key to provide when stopping jetty on executing java -DSTOP.KEY=<stopKey> -DSTOP.PORT=<stopPort> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort", 2);
                this.append(sb, "Port to listen to stop jetty on executing -DSTOP.PORT=<stopPort> -DSTOP.KEY=<stopKey> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "System properties to set before execution. Note that these properties will NOT override System properties that have been set on the command line or by the JVM. They WILL override System properties that have been set via systemPropertiesFile. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemPropertiesFile", 2);
                this.append(sb, "File containing system properties to be set before execution Note that these properties will NOT override System properties that have been set on the command line, by the JVM, or directly in the POM via systemProperties. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webApp", 2);
                this.append(sb, "The location of the war file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppConfig", 2);
                this.append(sb, "The 'virtual' webapp created by the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppXml", 2);
                this.append(sb, "Location of a context xml configuration file whose contents will be applied to the webapp AFTER anything in <webAppConfig>.Optional.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jetty:help", 0);
            this.append(sb, "Display help information on jetty-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jetty:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "jetty:run", 0);
            this.append(sb, "This goal is used in-situ on a Maven project without first requiring that the project is assembled into a war, saving time during the development cycle. The plugin forks a parallel lifecycle to ensure that the 'compile' phase has been completed before invoking Jetty. This means that you do not need to explicity execute a 'mvn compile' first. It also means that a 'mvn clean jetty:run' will ensure that a full fresh compile is done before invoking Jetty.\n\nOnce invoked, the plugin can be configured to run continuously, scanning for changes in the project and automatically performing a hot redeploy when necessary. This allows the developer to concentrate on coding changes to the project using their IDE of choice and have those changes immediately and transparently reflected in the running web container, eliminating development time that is wasted on rebuilding, reassembling and redeploying.\n\nYou may also specify the location of a jetty.xml file whose contents will be applied before any plugin configuration. This can be used, for example, to deploy a static webapp that is not part of your maven build.\n\nThere is a reference guide to the configuration parameters for this plugin, and more detailed information with examples in the Configuration Guide.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory containing generated classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectors", 2);
                this.append(sb, "List of connectors to use. If none are configured then the default is a single SelectChannelConnector at port 8080. You can override this default port number by using the system property jetty.port on the command line, eg: mvn -Djetty.port=9999 jetty:run", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextHandlers", 2);
                this.append(sb, "List of other contexts to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "daemon (Default: false)", 2);
                this.append(sb, "Determines whether or not the server blocks when started. The default behavior (daemon = false) will cause the server to pause other processes while it continues to handle web requests. This is useful when starting the server with the intent to work with it interactively.\n\nOften, it is desirable to let the server start and continue running subsequent processes in an automated build environment. This can be facilitated by setting daemon to true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "jettyConfig", 2);
                this.append(sb, "Location of a jetty xml configuration file whose contents will be applied before any plugin configuration. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "loginServices", 2);
                this.append(sb, "List of security realms to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reload (Default: automatic)", 2);
                this.append(sb, "reload can be set to either 'automatic' or 'manual' if 'manual' then the context can be reloaded by a linefeed in the console if 'automatic' then traditional reloading on changed files is enabled.", 3);
                this.append(sb, "", 0);
                this.append(sb, "requestLog", 2);
                this.append(sb, "A RequestLog implementation to use for the webapp at runtime. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scanIntervalSeconds (Default: 0)", 2);
                this.append(sb, "The interval in seconds to scan the webapp for changes and restart the context if necessary. Ignored if reload is enabled. Disabled by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scanTargetPatterns", 2);
                this.append(sb, "List of directories with ant-style <include> and <exclude> patterns for extra targets to periodically scan for changes. Can be used instead of, or in conjunction with <scanTargets>.Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scanTargets", 2);
                this.append(sb, "List of files or directories to additionally periodically scan for changes. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey", 2);
                this.append(sb, "Key to provide when stopping jetty on executing java -DSTOP.KEY=<stopKey> -DSTOP.PORT=<stopPort> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort", 2);
                this.append(sb, "Port to listen to stop jetty on executing -DSTOP.PORT=<stopPort> -DSTOP.KEY=<stopKey> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "System properties to set before execution. Note that these properties will NOT override System properties that have been set on the command line or by the JVM. They WILL override System properties that have been set via systemPropertiesFile. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemPropertiesFile", 2);
                this.append(sb, "File containing system properties to be set before execution Note that these properties will NOT override System properties that have been set on the command line, by the JVM, or directly in the POM via systemProperties. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "The directory containing generated test classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useTestClasspath (Default: false)", 2);
                this.append(sb, "If true, the <testOutputDirectory> and the dependencies of <scope>test<scope> will be put first on the runtime classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppConfig", 2);
                this.append(sb, "The 'virtual' webapp created by the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppSourceDirectory", 2);
                this.append(sb, "Root directory for all html/jsp etc files", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppXml", 2);
                this.append(sb, "Location of a context xml configuration file whose contents will be applied to the webapp AFTER anything in <webAppConfig>.Optional.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-exploded".equals(this.goal)) {
            this.append(sb, "jetty:run-exploded", 0);
            this.append(sb, "This goal is used to assemble your webapp into an exploded war and automatically deploy it to Jetty.\n\nOnce invoked, the plugin can be configured to run continuously, scanning for changes in the pom.xml and to WEB-INF/web.xml, WEB-INF/classes or WEB-INF/lib and hot redeploy when a change is detected.\n\nYou may also specify the location of a jetty.xml file whose contents will be applied before any plugin configuration. This can be used, for example, to deploy a static webapp that is not part of your maven build.\n\nThere is a reference guide to the configuration parameters for this plugin, and more detailed information with examples in the Configuration Guide.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "connectors", 2);
                this.append(sb, "List of connectors to use. If none are configured then the default is a single SelectChannelConnector at port 8080. You can override this default port number by using the system property jetty.port on the command line, eg: mvn -Djetty.port=9999 jetty:run", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextHandlers", 2);
                this.append(sb, "List of other contexts to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "daemon (Default: false)", 2);
                this.append(sb, "Determines whether or not the server blocks when started. The default behavior (daemon = false) will cause the server to pause other processes while it continues to handle web requests. This is useful when starting the server with the intent to work with it interactively.\n\nOften, it is desirable to let the server start and continue running subsequent processes in an automated build environment. This can be facilitated by setting daemon to true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "jettyConfig", 2);
                this.append(sb, "Location of a jetty xml configuration file whose contents will be applied before any plugin configuration. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "loginServices", 2);
                this.append(sb, "List of security realms to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reload (Default: automatic)", 2);
                this.append(sb, "reload can be set to either 'automatic' or 'manual' if 'manual' then the context can be reloaded by a linefeed in the console if 'automatic' then traditional reloading on changed files is enabled.", 3);
                this.append(sb, "", 0);
                this.append(sb, "requestLog", 2);
                this.append(sb, "A RequestLog implementation to use for the webapp at runtime. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scanIntervalSeconds (Default: 0)", 2);
                this.append(sb, "The interval in seconds to scan the webapp for changes and restart the context if necessary. Ignored if reload is enabled. Disabled by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey", 2);
                this.append(sb, "Key to provide when stopping jetty on executing java -DSTOP.KEY=<stopKey> -DSTOP.PORT=<stopPort> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort", 2);
                this.append(sb, "Port to listen to stop jetty on executing -DSTOP.PORT=<stopPort> -DSTOP.KEY=<stopKey> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "System properties to set before execution. Note that these properties will NOT override System properties that have been set on the command line or by the JVM. They WILL override System properties that have been set via systemPropertiesFile. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemPropertiesFile", 2);
                this.append(sb, "File containing system properties to be set before execution Note that these properties will NOT override System properties that have been set on the command line, by the JVM, or directly in the POM via systemProperties. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webApp", 2);
                this.append(sb, "The location of the war file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppConfig", 2);
                this.append(sb, "The 'virtual' webapp created by the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppXml", 2);
                this.append(sb, "Location of a context xml configuration file whose contents will be applied to the webapp AFTER anything in <webAppConfig>.Optional.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-war".equals(this.goal)) {
            this.append(sb, "jetty:run-war", 0);
            this.append(sb, "This goal is used to assemble your webapp into a war and automatically deploy it to Jetty.\n\nOnce invoked, the plugin can be configured to run continuously, scanning for changes in the project and to the war file and automatically performing a hot redeploy when necessary.\n\nYou may also specify the location of a jetty.xml file whose contents will be applied before any plugin configuration. This can be used, for example, to deploy a static webapp that is not part of your maven build.\n\nThere is a reference guide to the configuration parameters for this plugin, and more detailed information with examples in the Configuration Guide.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "connectors", 2);
                this.append(sb, "List of connectors to use. If none are configured then the default is a single SelectChannelConnector at port 8080. You can override this default port number by using the system property jetty.port on the command line, eg: mvn -Djetty.port=9999 jetty:run", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextHandlers", 2);
                this.append(sb, "List of other contexts to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "daemon (Default: false)", 2);
                this.append(sb, "Determines whether or not the server blocks when started. The default behavior (daemon = false) will cause the server to pause other processes while it continues to handle web requests. This is useful when starting the server with the intent to work with it interactively.\n\nOften, it is desirable to let the server start and continue running subsequent processes in an automated build environment. This can be facilitated by setting daemon to true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "jettyConfig", 2);
                this.append(sb, "Location of a jetty xml configuration file whose contents will be applied before any plugin configuration. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "loginServices", 2);
                this.append(sb, "List of security realms to set up. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reload (Default: automatic)", 2);
                this.append(sb, "reload can be set to either 'automatic' or 'manual' if 'manual' then the context can be reloaded by a linefeed in the console if 'automatic' then traditional reloading on changed files is enabled.", 3);
                this.append(sb, "", 0);
                this.append(sb, "requestLog", 2);
                this.append(sb, "A RequestLog implementation to use for the webapp at runtime. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scanIntervalSeconds (Default: 0)", 2);
                this.append(sb, "The interval in seconds to scan the webapp for changes and restart the context if necessary. Ignored if reload is enabled. Disabled by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopKey", 2);
                this.append(sb, "Key to provide when stopping jetty on executing java -DSTOP.KEY=<stopKey> -DSTOP.PORT=<stopPort> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort", 2);
                this.append(sb, "Port to listen to stop jetty on executing -DSTOP.PORT=<stopPort> -DSTOP.KEY=<stopKey> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "System properties to set before execution. Note that these properties will NOT override System properties that have been set on the command line or by the JVM. They WILL override System properties that have been set via systemPropertiesFile. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemPropertiesFile", 2);
                this.append(sb, "File containing system properties to be set before execution Note that these properties will NOT override System properties that have been set on the command line, by the JVM, or directly in the POM via systemProperties. Optional.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webApp", 2);
                this.append(sb, "The location of the war file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppConfig", 2);
                this.append(sb, "The 'virtual' webapp created by the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppXml", 2);
                this.append(sb, "Location of a context xml configuration file whose contents will be applied to the webapp AFTER anything in <webAppConfig>.Optional.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "jetty:stop", 0);
            this.append(sb, "JettyStopMojo - stops a running instance of jetty. The ff are required: -DstopKey=someKey -DstopPort=somePort", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "stopKey", 2);
                this.append(sb, "Key to provide when stopping jetty on executing java -DSTOP.KEY=<stopKey> -DSTOP.PORT=<stopPort> -jar start.jar --stop", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopPort", 2);
                this.append(sb, "Port to listen to stop jetty on sending stop command", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

