/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.AbstractStatisticsHandler;

public class AtomicStatisticsHandler
extends AbstractStatisticsHandler {
    private final transient AtomicLong _statsStartedAt = new AtomicLong();
    private final transient AtomicInteger _requests = new AtomicInteger();
    private final transient AtomicLong _minRequestTime = new AtomicLong();
    private final transient AtomicLong _maxRequestTime = new AtomicLong();
    private final transient AtomicLong _totalRequestTime = new AtomicLong();
    private final transient AtomicInteger _requestsActive = new AtomicInteger();
    private final transient AtomicInteger _requestsActiveMax = new AtomicInteger();
    private final transient AtomicInteger _responses1xx = new AtomicInteger();
    private final transient AtomicInteger _responses2xx = new AtomicInteger();
    private final transient AtomicInteger _responses3xx = new AtomicInteger();
    private final transient AtomicInteger _responses4xx = new AtomicInteger();
    private final transient AtomicInteger _responses5xx = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        this._requests.incrementAndGet();
        int actives = this._requestsActive.incrementAndGet();
        int oldMaxActives = this._requestsActiveMax.get();
        while (actives > oldMaxActives && !this._requestsActiveMax.compareAndSet(oldMaxActives, actives)) {
            oldMaxActives = this._requestsActiveMax.get();
        }
        long requestStartTime = System.currentTimeMillis();
        try {
            super.handle(target, request, response, dispatch);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            long requestTime = System.currentTimeMillis() - requestStartTime;
            actives = this._requestsActive.decrementAndGet();
            while (actives < 0 && !this._requestsActive.compareAndSet(actives, 0)) {
                actives = this._requestsActive.get();
            }
            long oldMinTime = this._minRequestTime.get();
            while (requestTime < oldMinTime && !this._minRequestTime.compareAndSet(oldMinTime, requestTime)) {
                oldMinTime = this._minRequestTime.get();
            }
            long oldMaxTime = this._maxRequestTime.get();
            while (requestTime > oldMaxTime && !this._maxRequestTime.compareAndSet(oldMaxTime, requestTime)) {
                oldMaxTime = this._maxRequestTime.get();
            }
            this._totalRequestTime.addAndGet(requestTime);
            Response jettyResponse = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
            switch (jettyResponse.getStatus() / 100) {
                case 1: {
                    this._responses1xx.incrementAndGet();
                    break;
                }
                case 2: {
                    this._responses2xx.incrementAndGet();
                    break;
                }
                case 3: {
                    this._responses3xx.incrementAndGet();
                    break;
                }
                case 4: {
                    this._responses4xx.incrementAndGet();
                    break;
                }
                case 5: {
                    this._responses5xx.incrementAndGet();
                    break;
                }
            }
            throw throwable;
        }
        long requestTime = System.currentTimeMillis() - requestStartTime;
        actives = this._requestsActive.decrementAndGet();
        while (actives < 0 && !this._requestsActive.compareAndSet(actives, 0)) {
            actives = this._requestsActive.get();
        }
        long oldMinTime = this._minRequestTime.get();
        while (requestTime < oldMinTime && !this._minRequestTime.compareAndSet(oldMinTime, requestTime)) {
            oldMinTime = this._minRequestTime.get();
        }
        long oldMaxTime = this._maxRequestTime.get();
        while (requestTime > oldMaxTime && !this._maxRequestTime.compareAndSet(oldMaxTime, requestTime)) {
            oldMaxTime = this._maxRequestTime.get();
        }
        this._totalRequestTime.addAndGet(requestTime);
        Response jettyResponse = response instanceof Response ? (Response)response : HttpConnection.getCurrentConnection().getResponse();
        switch (jettyResponse.getStatus() / 100) {
            case 1: {
                this._responses1xx.incrementAndGet();
                break;
            }
            case 2: {
                this._responses2xx.incrementAndGet();
                break;
            }
            case 3: {
                this._responses3xx.incrementAndGet();
                break;
            }
            case 4: {
                this._responses4xx.incrementAndGet();
                break;
            }
            case 5: {
                this._responses5xx.incrementAndGet();
                break;
            }
        }
        {
        }
    }

    public void statsReset() {
        this._statsStartedAt.set(System.currentTimeMillis());
        this._requests.set(0);
        this._minRequestTime.set(Long.MAX_VALUE);
        this._maxRequestTime.set(0L);
        this._totalRequestTime.set(0L);
        this._requestsActive.set(0);
        this._requestsActiveMax.set(0);
        this._responses1xx.set(0);
        this._responses2xx.set(0);
        this._responses3xx.set(0);
        this._responses4xx.set(0);
        this._responses5xx.set(0);
    }

    public int getRequests() {
        return this._requests.get();
    }

    public int getRequestsActive() {
        return this._requestsActive.get();
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax.get();
    }

    public int getResponses1xx() {
        return this._responses1xx.get();
    }

    public int getResponses2xx() {
        return this._responses2xx.get();
    }

    public int getResponses3xx() {
        return this._responses3xx.get();
    }

    public int getResponses4xx() {
        return this._responses4xx.get();
    }

    public int getResponses5xx() {
        return this._responses5xx.get();
    }

    public long getStatsOnMs() {
        return System.currentTimeMillis() - this._statsStartedAt.get();
    }

    public long getRequestTimeMin() {
        return this._minRequestTime.get();
    }

    public long getRequestTimeMax() {
        return this._maxRequestTime.get();
    }

    public long getRequestTimeTotal() {
        return this._totalRequestTime.get();
    }

    public long getRequestTimeAverage() {
        int requests = this.getRequests();
        return requests == 0 ? 0L : this.getRequestTimeTotal() / (long)requests;
    }
}

