/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.j2sehttpspi;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ThreadPoolExecutorAdapter
extends AbstractLifeCycle
implements ThreadPool {
    private ThreadPoolExecutor executor;

    public ThreadPoolExecutorAdapter(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public boolean dispatch(Runnable job) {
        try {
            this.executor.execute(job);
            return true;
        }
        catch (RejectedExecutionException e) {
            Log.warn((Throwable)e);
            return false;
        }
    }

    public int getIdleThreads() {
        return this.executor.getPoolSize() - this.executor.getActiveCount();
    }

    public int getThreads() {
        return this.executor.getPoolSize();
    }

    public boolean isLowOnThreads() {
        return this.executor.getActiveCount() >= this.executor.getMaximumPoolSize();
    }

    public void join() throws InterruptedException {
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean isFailed() {
        return false;
    }

    public boolean isRunning() {
        return !this.executor.isTerminated() && !this.executor.isTerminating();
    }

    public boolean isStarted() {
        return !this.executor.isTerminated() && !this.executor.isTerminating();
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopped() {
        return this.executor.isTerminated();
    }

    public boolean isStopping() {
        return this.executor.isTerminating();
    }

    protected void doStart() throws Exception {
        if (this.executor.isTerminated() || this.executor.isTerminating() || this.executor.isShutdown()) {
            throw new IllegalStateException("Cannot restart");
        }
    }

    protected void doStop() throws Exception {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
            this.executor.shutdownNow();
        }
    }
}

