/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mortbay.html.Tag;
import org.mortbay.log.Log;
import org.mortbay.util.IO;

public class Image
extends Tag {
    public Image(String src) {
        super("img");
        this.attribute("src", src);
    }

    public Image(String dirname, String src) {
        super("img");
        this.attribute("src", src);
        this.setSizeFromGif(dirname, src);
    }

    public Image(File gif) {
        super("img");
        this.attribute("src", gif.getName());
        this.setSizeFromGif(gif);
    }

    public Image(String src, int width, int height, int border) {
        this(src);
        this.width(width);
        this.height(height);
        this.border(border);
    }

    public Image border(int b) {
        this.attribute("border", b);
        return this;
    }

    public Image alt(String alt) {
        this.attribute("alt", alt);
        return this;
    }

    public Image setSizeFromGif(String dirname, String pathname) {
        String filename = dirname + pathname.replace('/', File.separatorChar);
        return this.setSizeFromGif(filename);
    }

    public Image setSizeFromGif(String filename) {
        return this.setSizeFromGif(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image setSizeFromGif(File gif) {
        if (gif.canRead()) {
            FileInputStream in = null;
            try {
                byte[] buf = new byte[10];
                in = new FileInputStream(gif);
                if (in.read(buf, 0, 10) == 10) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Image " + gif.getName() + " is " + ((0xFF & buf[7]) * 256 + (0xFF & buf[6])) + " x " + ((0xFF & buf[9]) * 256 + (0xFF & buf[8]))));
                    }
                    this.width((0xFF & buf[7]) * 256 + (0xFF & buf[6]));
                    this.height((0xFF & buf[9]) * 256 + (0xFF & buf[8]));
                }
                IO.close((InputStream)in);
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
            finally {
                IO.close(in);
            }
        }
        return this;
    }
}

