/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.example;

import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.deployer.ContextDeployer;
import org.mortbay.jetty.deployer.WebAppDeployer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;

public class LikeJettyXml {
    public static void main(String[] args) throws Exception {
        Server server = new Server();
        String jetty_home = System.getProperty("jetty.home");
        if (jetty_home == null) {
            jetty_home = ".";
        }
        BoundedThreadPool threadPool = new BoundedThreadPool();
        threadPool.setMaxThreads(100);
        server.setThreadPool((ThreadPool)threadPool);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(8080);
        connector.setMaxIdleTime(30000);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        handlers.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        server.setHandler((Handler)handlers);
        ContextDeployer deployer0 = new ContextDeployer();
        deployer0.setContexts(contexts);
        deployer0.setConfigurationDir(jetty_home + "/contexts");
        deployer0.setScanInterval(1);
        server.addLifeCycle((LifeCycle)deployer0);
        WebAppDeployer deployer1 = new WebAppDeployer();
        deployer1.setContexts((HandlerContainer)contexts);
        deployer1.setWebAppDir(jetty_home + "/webapps");
        deployer1.setParentLoaderPriority(false);
        deployer1.setExtract(true);
        deployer1.setAllowDuplicates(false);
        deployer1.setDefaultsDescriptor(jetty_home + "/etc/webdefault.xml");
        server.addLifeCycle((LifeCycle)deployer1);
        HashUserRealm userRealm = new HashUserRealm();
        userRealm.setName("Test Realm");
        userRealm.setConfig(jetty_home + "/etc/realm.properties");
        server.setUserRealms(new UserRealm[]{userRealm});
        NCSARequestLog requestLog = new NCSARequestLog(jetty_home + "/logs/jetty-yyyy-mm-dd.log");
        requestLog.setExtended(false);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        server.setStopAtShutdown(true);
        server.setSendServerVersion(true);
        server.start();
        server.join();
    }
}

