/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.example;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.StatisticsHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class ManyServletContexts {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        Context root = new Context((HandlerContainer)contexts, "/", 1);
        root.addServlet(new ServletHolder((Servlet)new HelloServlet("Ciao")), "/*");
        Context other = new Context((HandlerContainer)contexts, "/other", 1);
        other.addServlet("org.mortbay.jetty.example.ManyServletContexts$HelloServlet", "/*");
        StatisticsHandler stats = new StatisticsHandler();
        contexts.addHandler((Handler)stats);
        Context yetanother = new Context((HandlerContainer)stats, "/yo", 1);
        yetanother.addServlet(new ServletHolder((Servlet)new HelloServlet("YO!")), "/*");
        server.start();
        server.join();
    }

    public static class HelloServlet
    extends HttpServlet {
        String greeting = "Hello";

        public HelloServlet() {
        }

        public HelloServlet(String hi) {
            this.greeting = hi;
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            response.setStatus(200);
            response.getWriter().println("<h1>" + this.greeting + " SimpleServlet</h1>");
            response.getWriter().println("session=" + request.getSession(true).getId());
        }
    }
}

