/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client.webdav;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpEventListenerWrapper;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.SecurityListener;
import org.mortbay.jetty.client.webdav.MkcolExchange;
import org.mortbay.jetty.client.webdav.PropfindExchange;
import org.mortbay.jetty.client.webdav.WebdavSupportedExchange;
import org.mortbay.log.Log;
import org.mortbay.util.URIUtil;

public class WebdavListener
extends HttpEventListenerWrapper {
    private HttpDestination _destination;
    private HttpExchange _exchange;
    private boolean _webdavEnabled;

    public WebdavListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._destination = destination;
        this._exchange = ex;
        if ("PUT".equalsIgnoreCase(this._exchange.getMethod())) {
            this._webdavEnabled = true;
        }
    }

    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (!this._webdavEnabled) {
            super.onResponseStatus(version, status, reason);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("WebdavListener:Response Status: " + status));
        }
        if (status == 409 || status == 403) {
            if (this._webdavEnabled) {
                Log.debug((String)"WebdavListener:Response Status: dav enabled, taking a stab at resolving put issue");
                this.setDelegating(false);
            } else {
                Log.debug((String)"WebdavListener:Response Status: Webdav Disabled");
                this.setDelegating(true);
            }
        } else {
            this.setDelegating(true);
        }
        super.onResponseStatus(version, status, reason);
    }

    public void onResponseComplete() throws IOException {
        if (this.isDelegating()) {
            super.onResponseComplete();
        } else {
            try {
                if (this.resolveCollectionIssues()) {
                    this.setDelegating(true);
                    this._destination.resend(this._exchange);
                } else {
                    this.setDelegating(true);
                    super.onResponseComplete();
                }
            }
            catch (IOException ioe) {
                Log.debug((String)"WebdavListener:Complete:IOException: might not be dealing with dav server, delegate");
                super.onResponseComplete();
            }
        }
    }

    private boolean resolveCollectionIssues() throws IOException {
        String uri = this._exchange.getURI();
        String[] uriCollection = this._exchange.getURI().split("/");
        int checkNum = uriCollection.length;
        int rewind = 0;
        String parentUri = URIUtil.parentPath((String)uri);
        while (!this.checkExists(parentUri)) {
            ++rewind;
            parentUri = URIUtil.parentPath((String)parentUri);
        }
        if (this.checkWebdavSupported()) {
            int i = 0;
            while (i < rewind) {
                this.makeCollection(parentUri + "/" + uriCollection[checkNum - rewind - 1]);
                parentUri = parentUri + "/" + uriCollection[checkNum - rewind - 1];
                --rewind;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkExists(String uri) throws IOException {
        PropfindExchange propfindExchange = new PropfindExchange();
        propfindExchange.setAddress(this._exchange.getAddress());
        propfindExchange.setMethod("GET");
        propfindExchange.setScheme(this._exchange.getScheme());
        propfindExchange.setEventListener(new SecurityListener(this._destination, propfindExchange));
        propfindExchange.setConfigureListeners(false);
        propfindExchange.setURI(uri);
        this._destination.send(propfindExchange);
        try {
            propfindExchange.waitTilCompletion();
            return propfindExchange.exists();
        }
        catch (InterruptedException ie) {
            Log.ignore((Throwable)ie);
            return false;
        }
    }

    private boolean makeCollection(String uri) throws IOException {
        MkcolExchange mkcolExchange = new MkcolExchange();
        mkcolExchange.setAddress(this._exchange.getAddress());
        mkcolExchange.setMethod("MKCOL " + uri + " HTTP/1.1");
        mkcolExchange.setScheme(this._exchange.getScheme());
        mkcolExchange.setEventListener(new SecurityListener(this._destination, mkcolExchange));
        mkcolExchange.setConfigureListeners(false);
        mkcolExchange.setURI(uri);
        this._destination.send(mkcolExchange);
        try {
            mkcolExchange.waitTilCompletion();
            return mkcolExchange.exists();
        }
        catch (InterruptedException ie) {
            Log.ignore((Throwable)ie);
            return false;
        }
    }

    private boolean checkWebdavSupported() throws IOException {
        WebdavSupportedExchange supportedExchange = new WebdavSupportedExchange();
        supportedExchange.setAddress(this._exchange.getAddress());
        supportedExchange.setMethod("OPTIONS");
        supportedExchange.setScheme(this._exchange.getScheme());
        supportedExchange.setEventListener(new SecurityListener(this._destination, supportedExchange));
        supportedExchange.setConfigureListeners(false);
        supportedExchange.setURI(this._exchange.getURI());
        this._destination.send(supportedExchange);
        try {
            supportedExchange.waitTilCompletion();
            return supportedExchange.isWebdavSupported();
        }
        catch (InterruptedException ie) {
            Log.ignore((Throwable)ie);
            return false;
        }
    }
}

