/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public class HttpConnection
implements Connection {
    HttpDestination _destination;
    EndPoint _endp;
    HttpGenerator _generator;
    HttpParser _parser;
    boolean _http11 = true;
    Buffer _connectionHeader;
    Buffer _requestContentChunk;
    long _last;
    boolean _requestComplete;
    HttpExchange _exchange;
    HttpExchange _pipeline;
    Timeout.Task _timeout = new Timeout.Task(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            HttpExchange ex = null;
            try {
                HttpConnection httpConnection = HttpConnection.this;
                synchronized (httpConnection) {
                    ex = HttpConnection.this._exchange;
                    HttpConnection.this._exchange = null;
                    if (ex != null) {
                        HttpConnection.this._destination.returnConnection(HttpConnection.this, true);
                    }
                }
            }
            catch (Exception e) {
                Log.debug((Throwable)e);
            }
            finally {
                try {
                    HttpConnection.this._endp.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                if (ex.getStatus() < 7) {
                    ex.setStatus(8);
                }
            }
        }
    };

    HttpConnection(Buffers buffers, EndPoint endp, int hbs, int cbs) {
        this._endp = endp;
        this._generator = new HttpGenerator(buffers, endp, hbs, cbs);
        this._parser = new HttpParser(buffers, endp, (HttpParser.EventHandler)new Handler(), hbs, cbs);
    }

    public HttpDestination getDestination() {
        return this._destination;
    }

    public void setDestination(HttpDestination destination) {
        this._destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(HttpExchange ex) throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._exchange != null) {
                if (this._pipeline != null) {
                    throw new IllegalStateException(this + " PIPELINED!!!  _exchange=" + this._exchange);
                }
                this._pipeline = ex;
                return true;
            }
            if (!this._endp.isOpen()) {
                return false;
            }
            ex.setStatus(2);
            this._exchange = ex;
            if (this._endp.isBlocking()) {
                this.notify();
            } else {
                SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
                scep.scheduleWrite();
            }
            if (!this._endp.isBlocking()) {
                this._destination.getHttpClient().schedule(this._timeout);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handle() throws IOException {
        int no_progress = 0;
        int flushed = 0;
        while (this._endp.isOpen()) {
            HttpExchange ex;
            boolean close;
            HttpConnection httpConnection;
            Object var9_10;
            HttpConnection httpConnection2 = this;
            // MONITORENTER : httpConnection2
            while (this._exchange == null) {
                if (this._endp.isBlocking()) {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
                this._parser.fill();
                this._parser.skipCRLF();
                if (this._parser.isMoreInBuffer()) {
                    Log.warn((String)"unexpected data");
                    this._endp.close();
                }
                // MONITOREXIT : httpConnection2
                return;
            }
            // MONITOREXIT : httpConnection2
            if (this._exchange.getStatus() == 2) {
                no_progress = 0;
                this.commitRequest();
            }
            try {
                try {
                    long io;
                    block68: {
                        block67: {
                            io = 0L;
                            if (this._generator.isComplete()) break block67;
                            HttpConnection httpConnection3 = this;
                            // MONITORENTER : httpConnection3
                            if (this._exchange == null) {
                                // MONITOREXIT : httpConnection3
                                var9_10 = null;
                                if (!this._parser.isComplete() || !this._generator.isComplete()) continue;
                                this._destination.getHttpClient().cancel(this._timeout);
                                httpConnection = this;
                                // MONITORENTER : httpConnection
                                close = this.shouldClose();
                                this.reset(true);
                                no_progress = 0;
                                flushed = -1;
                                if (this._exchange != null) {
                                    if (this._exchange.getStatus() != 7) {
                                        Log.warn((String)("NOT COMPLETE! " + this._exchange));
                                        this._exchange.setStatus(7);
                                    }
                                    this._exchange = null;
                                    if (this._pipeline == null) {
                                        this._destination.returnConnection(this, close);
                                        if (close) {
                                            // MONITOREXIT : httpConnection
                                            return;
                                        }
                                    } else {
                                        if (close) {
                                            this._destination.returnConnection(this, close);
                                            this._destination.send(this._pipeline);
                                            this._pipeline = null;
                                            // MONITOREXIT : httpConnection
                                            return;
                                        }
                                        ex = this._pipeline;
                                        this._pipeline = null;
                                        this.send(ex);
                                    }
                                }
                                // MONITOREXIT : httpConnection
                                continue;
                            }
                            io = this._generator.flush();
                            flushed = (int)((long)flushed + io);
                            // MONITOREXIT : httpConnection3
                            if (!this._generator.isComplete()) {
                                InputStream in = this._exchange.getRequestContentSource();
                                if (in != null) {
                                    if (this._requestContentChunk == null || this._requestContentChunk.length() == 0) {
                                        this._requestContentChunk = this._exchange.getRequestContentChunk();
                                        if (this._requestContentChunk != null) {
                                            this._generator.addContent(this._requestContentChunk, false);
                                        } else {
                                            this._generator.complete();
                                        }
                                        io += this._generator.flush();
                                    }
                                    break block68;
                                } else {
                                    this._generator.complete();
                                }
                            }
                            break block68;
                        }
                        if (!this._requestComplete) {
                            this._requestComplete = true;
                            this._exchange.onRequestComplete();
                        }
                    }
                    if (!this._parser.isComplete() && this._generator.isCommitted()) {
                        long filled = this._parser.parseAvailable();
                        io += filled;
                    }
                    if (io > 0L) {
                        no_progress = 0;
                    } else if (no_progress++ >= 2 && !this._endp.isBlocking()) {
                        var9_10 = null;
                        if (!this._parser.isComplete()) return;
                        if (!this._generator.isComplete()) return;
                        this._destination.getHttpClient().cancel(this._timeout);
                        httpConnection = this;
                        // MONITORENTER : httpConnection
                        close = this.shouldClose();
                        this.reset(true);
                        no_progress = 0;
                        flushed = -1;
                        if (this._exchange != null) {
                            if (this._exchange.getStatus() != 7) {
                                Log.warn((String)("NOT COMPLETE! " + this._exchange));
                                this._exchange.setStatus(7);
                            }
                            this._exchange = null;
                            if (this._pipeline == null) {
                                this._destination.returnConnection(this, close);
                                if (!close) return;
                                // MONITOREXIT : httpConnection
                                return;
                            } else {
                                if (close) {
                                    this._destination.returnConnection(this, close);
                                    this._destination.send(this._pipeline);
                                    this._pipeline = null;
                                    // MONITOREXIT : httpConnection
                                    return;
                                }
                                ex = this._pipeline;
                                this._pipeline = null;
                                this.send(ex);
                            }
                        }
                        // MONITOREXIT : httpConnection
                        return;
                    }
                    var9_10 = null;
                }
                catch (IOException e) {
                    HttpConnection httpConnection4 = this;
                    // MONITORENTER : httpConnection4
                    if (this._exchange != null) {
                        this._exchange.onException(e);
                        this._exchange.setStatus(9);
                    }
                    // MONITOREXIT : httpConnection4
                    var9_10 = null;
                    if (!this._parser.isComplete() || !this._generator.isComplete()) continue;
                    this._destination.getHttpClient().cancel(this._timeout);
                    httpConnection = this;
                    // MONITORENTER : httpConnection
                    close = this.shouldClose();
                    this.reset(true);
                    no_progress = 0;
                    flushed = -1;
                    if (this._exchange != null) {
                        if (this._exchange.getStatus() != 7) {
                            Log.warn((String)("NOT COMPLETE! " + this._exchange));
                            this._exchange.setStatus(7);
                        }
                        this._exchange = null;
                        if (this._pipeline == null) {
                            this._destination.returnConnection(this, close);
                            if (close) {
                                // MONITOREXIT : httpConnection
                                return;
                            }
                        } else {
                            if (close) {
                                this._destination.returnConnection(this, close);
                                this._destination.send(this._pipeline);
                                this._pipeline = null;
                                // MONITOREXIT : httpConnection
                                return;
                            }
                            ex = this._pipeline;
                            this._pipeline = null;
                            this.send(ex);
                        }
                    }
                    // MONITOREXIT : httpConnection
                    continue;
                }
                if (!this._parser.isComplete() || !this._generator.isComplete()) continue;
                this._destination.getHttpClient().cancel(this._timeout);
                httpConnection = this;
                // MONITORENTER : httpConnection
                close = this.shouldClose();
                this.reset(true);
                no_progress = 0;
                flushed = -1;
                if (this._exchange != null) {
                    if (this._exchange.getStatus() != 7) {
                        Log.warn((String)("NOT COMPLETE! " + this._exchange));
                        this._exchange.setStatus(7);
                    }
                    this._exchange = null;
                    if (this._pipeline == null) {
                        this._destination.returnConnection(this, close);
                        if (close) {
                            // MONITOREXIT : httpConnection
                            return;
                        }
                    } else {
                        if (close) {
                            this._destination.returnConnection(this, close);
                            this._destination.send(this._pipeline);
                            this._pipeline = null;
                            // MONITOREXIT : httpConnection
                            return;
                        }
                        ex = this._pipeline;
                        this._pipeline = null;
                        this.send(ex);
                    }
                }
                // MONITOREXIT : httpConnection
            }
            catch (Throwable throwable) {
                var9_10 = null;
                if (!this._parser.isComplete()) throw throwable;
                if (!this._generator.isComplete()) throw throwable;
                this._destination.getHttpClient().cancel(this._timeout);
                httpConnection = this;
                // MONITORENTER : httpConnection
                close = this.shouldClose();
                this.reset(true);
                no_progress = 0;
                flushed = -1;
                if (this._exchange != null) {
                    if (this._exchange.getStatus() != 7) {
                        Log.warn((String)("NOT COMPLETE! " + this._exchange));
                        this._exchange.setStatus(7);
                    }
                    this._exchange = null;
                    if (this._pipeline == null) {
                        this._destination.returnConnection(this, close);
                        if (!close) throw throwable;
                        // MONITOREXIT : httpConnection
                        return;
                    } else {
                        if (close) {
                            this._destination.returnConnection(this, close);
                            this._destination.send(this._pipeline);
                            this._pipeline = null;
                            // MONITOREXIT : httpConnection
                            return;
                        }
                        ex = this._pipeline;
                        this._pipeline = null;
                        this.send(ex);
                    }
                }
                // MONITOREXIT : httpConnection
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            return this._exchange == null;
        }
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRequest() throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._exchange.getStatus() != 2) {
                throw new IllegalStateException();
            }
            this._exchange.setStatus(3);
            this._generator.setVersion(this._exchange._version);
            this._generator.setRequest(this._exchange._method, this._exchange._uri);
            if (this._exchange._version >= 11 && !this._exchange._requestFields.containsKey(HttpHeaders.HOST_BUFFER)) {
                this._exchange._requestFields.add(HttpHeaders.HOST_BUFFER, this._destination.getHostHeader());
            }
            if (this._exchange._requestContent != null) {
                this._exchange._requestFields.putLongField("Content-Length", (long)this._exchange._requestContent.length());
                this._generator.completeHeader(this._exchange._requestFields, false);
                this._generator.addContent(this._exchange._requestContent, true);
            } else if (this._exchange._requestContentSource != null) {
                this._generator.completeHeader(this._exchange._requestFields, false);
                int available = this._exchange._requestContentSource.available();
                if (available > 0) {
                    byte[] buf = new byte[available];
                    int length = this._exchange._requestContentSource.read(buf);
                    this._generator.addContent((Buffer)new ByteArrayBuffer(buf, 0, length), false);
                }
            } else {
                this._exchange._requestFields.remove("Content-Length");
                this._generator.completeHeader(this._exchange._requestFields, true);
            }
            this._exchange.setStatus(4);
        }
    }

    protected void reset(boolean returnBuffers) throws IOException {
        this._requestComplete = false;
        this._connectionHeader = null;
        this._parser.reset(returnBuffers);
        this._generator.reset(returnBuffers);
        this._http11 = true;
    }

    private boolean shouldClose() {
        if (HttpHeaderValues.CLOSE_BUFFER.equals(this._connectionHeader)) {
            return true;
        }
        if (HttpHeaderValues.KEEP_ALIVE_BUFFER.equals(this._connectionHeader)) {
            return false;
        }
        return !this._http11;
    }

    public String toString() {
        return "HttpConnection@" + this.hashCode() + "//" + this._destination.getAddress().getHostName() + ":" + this._destination.getAddress().getPort();
    }

    public String toDetailString() {
        return this.toString() + " ex=" + this._exchange + " " + this._timeout.getAge();
    }

    public long getLast() {
        return this._last;
    }

    public void setLast(long last) {
        this._last = last;
    }

    private class Handler
    extends HttpParser.EventHandler {
        private Handler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
            throw new IllegalStateException();
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpConnection.this._http11 = HttpVersions.HTTP_1_1_BUFFER.equals(version);
            HttpConnection.this._exchange.onResponseStatus(version, status, reason);
            HttpConnection.this._exchange.setStatus(5);
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            if (HttpHeaders.CACHE.getOrdinal(name) == 1) {
                HttpConnection.this._connectionHeader = HttpHeaderValues.CACHE.lookup(value);
            }
            HttpConnection.this._exchange.onResponseHeader(name, value);
        }

        public void headerComplete() throws IOException {
            HttpConnection.this._exchange.setStatus(6);
        }

        public void content(Buffer ref) throws IOException {
            HttpConnection.this._exchange.onResponseContent(ref);
        }

        public void messageComplete(long contextLength) throws IOException {
            HttpConnection.this._exchange.setStatus(7);
        }
    }
}

