/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.client.CachedExchange;
import org.mortbay.util.StringUtil;

public class ContentExchange
extends CachedExchange {
    int _contentLength = 1024;
    String _encoding = "utf-8";
    ByteArrayOutputStream _responseContent;
    File _fileForUpload;

    public ContentExchange() {
        super(false);
    }

    public ContentExchange(boolean cacheFields) {
        super(cacheFields);
    }

    public String getResponseContent() throws UnsupportedEncodingException {
        if (this._responseContent != null) {
            return this._responseContent.toString(this._encoding);
        }
        return null;
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        super.onResponseHeader(name, value);
        int header = HttpHeaders.CACHE.getOrdinal(value);
        switch (header) {
            case 12: {
                this._contentLength = BufferUtil.toInt((Buffer)value);
                break;
            }
            case 16: {
                String mime = StringUtil.asciiToLowerCase((String)value.toString());
                int i = mime.indexOf("charset=");
                if (i > 0 && (i = (mime = mime.substring(i + 8)).indexOf(59)) > 0) {
                    mime = mime.substring(0, i);
                }
                if (mime == null || mime.length() <= 0) break;
                this._encoding = mime;
            }
        }
    }

    protected void onResponseContent(Buffer content) throws IOException {
        super.onResponseContent(content);
        if (this._responseContent == null) {
            this._responseContent = new ByteArrayOutputStream(this._contentLength);
        }
        content.writeTo((OutputStream)this._responseContent);
    }

    protected void onRetry() throws IOException {
        if (this._fileForUpload != null) {
            this._requestContent = null;
            this._requestContentSource = this.getInputStream();
        } else if (this._requestContentSource != null) {
            throw new IOException("Unsupported Retry attempt, no registered file for upload.");
        }
        super.onRetry();
    }

    private InputStream getInputStream() throws IOException {
        return new FileInputStream(this._fileForUpload);
    }

    public File getFileForUpload() {
        return this._fileForUpload;
    }

    public void setFileForUpload(File fileForUpload) throws IOException {
        this._fileForUpload = fileForUpload;
        this._requestContentSource = this.getInputStream();
    }
}

